/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.plang;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.knox.gateway.plang.AbstractSyntaxTree;
import org.apache.knox.gateway.plang.Arity;
import org.apache.knox.gateway.plang.InterpreterException;
import org.apache.knox.gateway.plang.TypeException;
import org.apache.knox.gateway.plang.UndefinedSymbolException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Interpreter {
    private static final Logger LOG = LogManager.getLogger(Interpreter.class);
    private final Map<String, SpecialForm> specialForms = new HashMap<String, SpecialForm>();
    private final Map<String, Func> functions = new HashMap<String, Func>();
    private final Map<String, Object> constants = new HashMap<String, Object>();

    public Interpreter() {
        this.specialForms.put("or", args -> {
            Arity.min(1).check("or", args);
            return args.stream().anyMatch(each -> (Boolean)this.eval((AbstractSyntaxTree)each));
        });
        this.specialForms.put("and", args -> {
            Arity.min(1).check("and", args);
            return args.stream().allMatch(each -> (Boolean)this.eval((AbstractSyntaxTree)each));
        });
        this.addFunction("not", Arity.UNARY, args -> (Boolean)args.get(0) == false);
        this.addFunction("=", Arity.BINARY, args -> Interpreter.equalTo(args.get(0), args.get(1)));
        this.addFunction("!=", Arity.BINARY, args -> !Interpreter.equalTo(args.get(0), args.get(1)));
        this.addFunction("match", Arity.BINARY, args -> args.get(0) instanceof String ? Pattern.matches((String)args.get(1), (String)args.get(0)) : ((List)args.get(0)).stream().anyMatch(each -> Pattern.matches((String)args.get(1), each)));
        this.addFunction("size", Arity.UNARY, args -> ((Collection)args.get(0)).size());
        this.addFunction("empty", Arity.UNARY, args -> ((Collection)args.get(0)).isEmpty());
        this.addFunction("username", Arity.UNARY, args -> this.constants.get("username").equals(args.get(0)));
        this.addFunction("member", Arity.UNARY, args -> ((List)this.constants.get("groups")).contains((String)args.get(0)));
        this.addFunction("lowercase", Arity.UNARY, args -> ((String)args.get(0)).toLowerCase(Locale.getDefault()));
        this.addFunction("uppercase", Arity.UNARY, args -> ((String)args.get(0)).toUpperCase(Locale.getDefault()));
        this.addFunction("print", Arity.min(1), args -> {
            args.forEach(arg -> LOG.info(arg == null ? "null" : arg.toString()));
            return false;
        });
        this.constants.put("true", true);
        this.constants.put("false", false);
    }

    private static boolean equalTo(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return Double.compare(((Number)a).doubleValue(), ((Number)b).doubleValue()) == 0;
        }
        return a.equals(b);
    }

    public void addConstant(String name, Object value) {
        this.constants.put(name, value);
    }

    public void addFunction(String name, Arity arity, Func func) {
        this.functions.put(name, parameters -> {
            arity.check(name, parameters);
            return func.call(parameters);
        });
    }

    public Object eval(AbstractSyntaxTree ast) {
        try {
            if (ast == null) {
                return null;
            }
            if (ast.isAtom()) {
                return ast.isStr() ? ast.strValue() : (ast.isNumber() ? ast.numValue() : this.lookupConstant(ast));
            }
            if (ast.isFunction()) {
                SpecialForm specialForm = this.specialForms.get(ast.functionName());
                if (specialForm != null) {
                    return specialForm.call(ast.functionParameters());
                }
                Func func = this.functions.get(ast.functionName());
                if (func == null) {
                    throw new UndefinedSymbolException(ast.functionName(), "function");
                }
                return func.call(ast.functionParameters().stream().map(this::eval).collect(Collectors.toList()));
            }
            throw new InterpreterException("Unknown token: " + ast.token());
        }
        catch (ClassCastException e) {
            throw new TypeException("Type error at: " + ast, e);
        }
    }

    private Object lookupConstant(AbstractSyntaxTree ast) {
        Object var = this.constants.get(ast.token());
        if (var == null) {
            throw new UndefinedSymbolException(ast.token(), "variable");
        }
        return var;
    }

    private static interface SpecialForm {
        public Object call(List<AbstractSyntaxTree> var1);
    }

    public static interface Func {
        public Object call(List<Object> var1);
    }
}

