/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.common;

import java.util.Iterator;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.DimensionRangeInfo;
import org.apache.kylin.cube.common.SegmentPruner;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;

public class TupleFilterNode {
    private TupleFilter filter;

    public TupleFilterNode(TupleFilter filter) {
        this.filter = filter;
    }

    public boolean checkSeg(CubeSegment seg) {
        if (this.filter == null) {
            return true;
        }
        if (this.filter instanceof CompareTupleFilter) {
            CompareTupleFilter compareTupleFilter = (CompareTupleFilter)this.filter;
            TblColRef tblColRef = compareTupleFilter.getColumn();
            if (tblColRef == null) {
                return true;
            }
            DimensionRangeInfo dimRangeInfo = seg.getDimensionRangeInfoMap().get(tblColRef.getIdentity());
            if (dimRangeInfo == null) {
                dimRangeInfo = SegmentPruner.tryDeduceRangeFromPartitionCol(seg, tblColRef);
            }
            if (dimRangeInfo == null) {
                return true;
            }
            String minVal = dimRangeInfo.getMin();
            String maxVal = dimRangeInfo.getMax();
            return SegmentPruner.satisfy(compareTupleFilter, minVal, maxVal);
        }
        if (this.filter instanceof LogicalTupleFilter) {
            Iterator<? extends TupleFilter> iterator;
            if (this.filter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
                for (TupleFilter tupleFilter : this.filter.getChildren()) {
                    if (new TupleFilterNode(tupleFilter).checkSeg(seg)) continue;
                    return false;
                }
                return true;
            }
            if (this.filter.getOperator() == TupleFilter.FilterOperatorEnum.OR) {
                for (TupleFilter tupleFilter : this.filter.getChildren()) {
                    if (!new TupleFilterNode(tupleFilter).checkSeg(seg)) continue;
                    return true;
                }
                return false;
            }
            if (this.filter.getOperator() == TupleFilter.FilterOperatorEnum.NOT && (iterator = this.filter.getChildren().iterator()).hasNext()) {
                TupleFilter tupleFilter = iterator.next();
                return !new TupleFilterNode(tupleFilter).checkSeg(seg);
            }
        }
        return true;
    }
}

