/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableList;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableSet;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class BitsChromosomeHelper {
    public final double spaceLimit;
    private final CuboidStats cuboidStats;
    private final CuboidEncoder cuboidEncoder;

    public BitsChromosomeHelper(double spaceLimit, CuboidStats cuboidStats) {
        this.spaceLimit = spaceLimit;
        this.cuboidStats = cuboidStats;
        this.cuboidEncoder = new CuboidEncoder(cuboidStats.getAllCuboidsForSelection());
    }

    public ImmutableSet<Long> getMandatoryCuboids() {
        return this.cuboidStats.getAllCuboidsForMandatory();
    }

    public List<Long> toCuboidList(BitSet bits) {
        return this.cuboidEncoder.toCuboidList(bits);
    }

    public double getCuboidSize(Set<Long> cuboids) {
        double ret = 0.0;
        for (Long cuboid : cuboids) {
            ret += this.cuboidStats.getCuboidSize(cuboid).doubleValue();
        }
        return ret;
    }

    public double getCuboidSizeByBitIndex(int index) {
        return this.cuboidStats.getCuboidSize((Long)this.cuboidEncoder.cuboidDomain.get(index));
    }

    public int getLength() {
        return this.cuboidEncoder.cuboidDomain.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitsChromosomeHelper that = (BitsChromosomeHelper)o;
        return this.cuboidEncoder != null ? this.cuboidEncoder.equals(that.cuboidEncoder) : that.cuboidEncoder == null;
    }

    public int hashCode() {
        return this.cuboidEncoder != null ? this.cuboidEncoder.hashCode() : 0;
    }

    private static class CuboidEncoder {
        public final ImmutableList<Long> cuboidDomain;

        public CuboidEncoder(Set<Long> cuboidSet) {
            ArrayList<Long> cuboidList = Lists.newArrayList(cuboidSet);
            Collections.sort(cuboidList, Collections.reverseOrder());
            this.cuboidDomain = ImmutableList.copyOf(cuboidList);
        }

        public List<Long> toCuboidList(BitSet bits) {
            ArrayList<Long> cuboids = Lists.newArrayListWithExpectedSize(bits.cardinality());
            int i = bits.nextSetBit(0);
            while (i >= 0) {
                cuboids.add((Long)this.cuboidDomain.get(i));
                i = bits.nextSetBit(i + 1);
            }
            return cuboids;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CuboidEncoder that = (CuboidEncoder)o;
            return this.cuboidDomain != null ? this.cuboidDomain.equals(that.cuboidDomain) : that.cuboidDomain == null;
        }

        public int hashCode() {
            return this.cuboidDomain != null ? this.cuboidDomain.hashCode() : 0;
        }
    }
}

