/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.MoreObjects;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class DimensionDesc
implements Serializable {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="table")
    private String table;
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="derived")
    private String[] derived;
    private TableRef tableRef;
    private JoinDesc join;
    private TblColRef[] columnRefs;

    public void init(CubeDesc cubeDesc) {
        DataModelDesc model = cubeDesc.getModel();
        if (this.name != null) {
            this.name = this.name.toUpperCase(Locale.ROOT);
        }
        this.tableRef = model.findTable(this.table);
        this.table = this.tableRef.getAlias();
        this.join = null;
        for (JoinTableDesc joinTable : model.getJoinTables()) {
            if (!joinTable.getTableRef().equals(this.tableRef)) continue;
            this.join = joinTable.getJoin();
            break;
        }
        if (this.column != null && !"{FK}".equals(this.column)) {
            this.column = model.findColumn(this.table, this.column).getName();
        }
        if (this.derived != null && this.derived.length == 0) {
            this.derived = null;
        }
        if (this.derived != null) {
            for (int i = 0; i < this.derived.length; ++i) {
                this.derived[i] = model.findColumn(this.table, this.derived[i]).getName();
            }
        }
        if (this.derived != null && this.join == null) {
            throw new IllegalStateException("Derived can only be defined on lookup table, cube " + cubeDesc + ", " + this);
        }
    }

    public boolean isDerived() {
        return this.derived != null;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public JoinDesc getJoin() {
        return this.join;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TblColRef[] getColumnRefs() {
        return this.columnRefs;
    }

    public void setColumnRefs(TblColRef[] colRefs) {
        this.columnRefs = colRefs;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String[] getDerived() {
        return this.derived;
    }

    public void setDerived(String[] derived) {
        this.derived = derived;
    }

    public TableRef getTableRef() {
        return this.tableRef;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("table", this.table).add("column", this.column).add("derived", Arrays.toString(this.derived)).add("join", this.join).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionDesc that = (DimensionDesc)o;
        if (this.column != null ? !this.column.equals(that.column) : that.column != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.table != null ? !this.table.equals(that.table) : that.table != null) {
            return false;
        }
        return !(this.derived != null ? !Arrays.equals(this.derived, that.derived) : that.derived != null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        result = 31 * result + (this.derived == null ? 0 : Arrays.hashCode(this.derived));
        return result;
    }
}

