/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.flink;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.flink.FlinkCubingMerge;
import org.apache.kylin.engine.flink.FlinkExecutable;
import org.apache.kylin.engine.flink.FlinkMergingDictionary;
import org.apache.kylin.engine.flink.FlinkUtil;
import org.apache.kylin.engine.flink.IFlinkInput;
import org.apache.kylin.engine.flink.IFlinkOutput;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkBatchMergeJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(FlinkBatchMergeJobBuilder2.class);
    private final IFlinkOutput.IFlinkBatchMergeOutputSide outputSide;
    private final IFlinkInput.IFlinkBatchMergeInputSide inputSide;

    public FlinkBatchMergeJobBuilder2(CubeSegment mergeSegment, String submitter) {
        super(mergeSegment, submitter);
        this.outputSide = FlinkUtil.getBatchMergeOutputSide2(this.seg);
        this.inputSide = FlinkUtil.getBatchMergeInputSide(this.seg);
    }

    public CubingJob build() {
        logger.info("Flink job to MERGE segment " + this.seg);
        CubeSegment cubeSegment = this.seg;
        CubingJob result = CubingJob.createMergeJob(cubeSegment, this.submitter, this.config);
        String jobId = result.getId();
        Segments<CubeSegment> mergingSegments = cubeSegment.getCubeInstance().getMergingSegments(cubeSegment);
        Preconditions.checkState(mergingSegments.size() > 1, "there should be more than 2 segments to merge, target segment " + cubeSegment);
        ArrayList<String> mergingSegmentIds = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingSegmentIds.add(merging.getUuid());
        }
        this.inputSide.addStepPhase1_MergeDictionary(result);
        result.addTask(this.createMergeDictionaryFlinkStep(cubeSegment, jobId, mergingSegmentIds));
        result.addTask(this.createUpdateDictionaryStep(cubeSegment, jobId, mergingSegmentIds));
        this.outputSide.addStepPhase1_MergeDictionary(result);
        result.addTask(this.createMergeCuboidDataFlinkStep(cubeSegment, mergingSegments, jobId));
        this.outputSide.addStepPhase2_BuildCube(this.seg, mergingSegments, result);
        result.addTask(this.createUpdateCubeInfoAfterMergeStep(mergingSegmentIds, jobId));
        this.outputSide.addStepPhase3_Cleanup(result);
        return result;
    }

    public FlinkExecutable createMergeDictionaryFlinkStep(CubeSegment seg, String jobID, List<String> mergingSegmentIds) {
        FlinkExecutable flinkExecutable = new FlinkExecutable();
        flinkExecutable.setClassName(FlinkMergingDictionary.class.getName());
        flinkExecutable.setParam(FlinkMergingDictionary.OPTION_CUBE_NAME.getOpt(), seg.getRealization().getName());
        flinkExecutable.setParam(FlinkMergingDictionary.OPTION_SEGMENT_ID.getOpt(), seg.getUuid());
        flinkExecutable.setParam(FlinkMergingDictionary.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(seg.getConfig(), jobID));
        flinkExecutable.setParam(FlinkMergingDictionary.OPTION_MERGE_SEGMENT_IDS.getOpt(), StringUtil.join(mergingSegmentIds, ","));
        flinkExecutable.setParam(FlinkMergingDictionary.OPTION_OUTPUT_PATH_DICT.getOpt(), this.getDictInfoPath(jobID));
        flinkExecutable.setParam(FlinkMergingDictionary.OPTION_OUTPUT_PATH_STAT.getOpt(), this.getStatisticsPath(jobID));
        flinkExecutable.setJobId(jobID);
        flinkExecutable.setName("Merge Cuboid Dictionary");
        flinkExecutable.setFlinkConfigName("mergedict");
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator(jars, seg.getConfig().getFlinkAdditionalJars());
        flinkExecutable.setJars(jars.toString());
        return flinkExecutable;
    }

    public FlinkExecutable createMergeCuboidDataFlinkStep(CubeSegment seg, List<CubeSegment> mergingSegments, String jobID) {
        ArrayList<String> mergingCuboidPaths = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingCuboidPaths.add(this.getCuboidRootPath(merging));
        }
        String formattedPath = StringUtil.join(mergingCuboidPaths, ",");
        String outputPath = this.getCuboidRootPath(jobID);
        FlinkExecutable flinkExecutable = new FlinkExecutable();
        flinkExecutable.setClassName(FlinkCubingMerge.class.getName());
        flinkExecutable.setParam(FlinkCubingMerge.OPTION_CUBE_NAME.getOpt(), seg.getRealization().getName());
        flinkExecutable.setParam(FlinkCubingMerge.OPTION_SEGMENT_ID.getOpt(), seg.getUuid());
        flinkExecutable.setParam(FlinkCubingMerge.OPTION_INPUT_PATH.getOpt(), formattedPath);
        flinkExecutable.setParam(FlinkCubingMerge.OPTION_META_URL.getOpt(), this.getSegmentMetadataUrl(seg.getConfig(), jobID));
        flinkExecutable.setParam(FlinkCubingMerge.OPTION_OUTPUT_PATH.getOpt(), outputPath);
        flinkExecutable.setJobId(jobID);
        flinkExecutable.setName("Merge Cuboid Data");
        StringBuilder jars = new StringBuilder();
        StringUtil.appendWithSeparator(jars, seg.getConfig().getFlinkAdditionalJars());
        flinkExecutable.setJars(jars.toString());
        return flinkExecutable;
    }
}

