/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.BuildGlobalHiveDictPartBuildMapper;
import org.apache.kylin.engine.mr.steps.BuildGlobalHiveDictPartBuildReducer;
import org.apache.kylin.engine.mr.steps.BuildGlobalHiveDictPartPartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildGlobalHiveDictPartBuildJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(BuildGlobalHiveDictPartBuildJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Options options = new Options();
        String[] dicColsArr = null;
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            this.parseOptions(options, args);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            dicColsArr = config.getMrHiveDictColumnsExcludeRefColumns();
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            CubeManager cubeMgr = CubeManager.getInstance(config);
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment segment = cube.getSegmentById(segmentID);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            logger.info("Starting: " + this.job.getJobName());
            this.job.setJarByClass(BuildGlobalHiveDictPartBuildJob.class);
            this.setJobClasspath(this.job, cube.getConfig());
            this.setInput(this.job, dicColsArr, this.getInputPath(config, segment));
            this.setOutput(this.job, dicColsArr, this.getOptionValue(OPTION_OUTPUT_PATH));
            this.job.getConfiguration().setBoolean("mapreduce.output.fileoutputformat.compress", false);
            this.setReduceNum(this.job, config);
            this.job.setInputFormatClass(KeyValueTextInputFormat.class);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(NullWritable.class);
            this.job.setOutputKeyClass(LongWritable.class);
            this.job.setOutputValueClass(Text.class);
            this.job.setMapperClass(BuildGlobalHiveDictPartBuildMapper.class);
            this.job.setPartitionerClass(BuildGlobalHiveDictPartPartitioner.class);
            this.job.setReducerClass(BuildGlobalHiveDictPartBuildReducer.class);
            LazyOutputFormat.setOutputFormatClass((Job)this.job, TextOutputFormat.class);
            Path baseOutputPath = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            this.deletePath(this.job.getConfiguration(), baseOutputPath);
            this.attachSegmentMetadataWithDict(segment, this.job.getConfiguration());
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void setOutput(Job job, String[] dicColsArr, String outputBase) {
        for (int i = 0; i < dicColsArr.length; ++i) {
            MultipleOutputs.addNamedOutput((Job)job, (String)(i + ""), TextOutputFormat.class, LongWritable.class, Text.class);
        }
        Path outputPath = new Path(outputBase);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
    }

    private void setInput(Job job, String[] dicColsArray, String inputBase) throws IOException {
        StringBuffer paths = new StringBuffer();
        for (String col : dicColsArray) {
            paths.append(inputBase).append("/dict_column=").append(col).append(",");
        }
        paths.delete(paths.length() - 1, paths.length());
        FileInputFormat.setInputPaths((Job)job, (String)paths.toString());
    }

    private void setReduceNum(Job job, KylinConfig config) {
        Integer[] reduceNumArr = config.getMrHiveDictColumnsReduceNumExcludeRefCols();
        int totalReduceNum = 0;
        for (Integer num : reduceNumArr) {
            totalReduceNum += num.intValue();
        }
        logger.info("BuildGlobalHiveDictPartBuildJob total reduce num is {}", (Object)totalReduceNum);
        job.setNumReduceTasks(totalReduceNum);
    }

    private String getInputPath(KylinConfig config, CubeSegment segment) {
        String dbDir = config.getIntermediateTableDatabaseDir();
        String tableName = EngineFactory.getJoinedFlatTableDesc(segment).getTableName() + config.getMrHiveDistinctValueTableSuffix();
        String input = dbDir + "/" + tableName;
        logger.info("part build base input path:" + input);
        return input;
    }
}

