/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.IOException;
import java.util.Locale;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.streaming.ColumnToRowMapper;
import org.apache.kylin.engine.mr.streaming.ColumnToRowReducer;
import org.apache.kylin.engine.mr.streaming.ColumnarSplitDataInputFormat;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnToRowJob
extends AbstractHadoopJob {
    private static final Logger logger = LoggerFactory.getLogger(ColumnToRowJob.class);
    private static final long DEFAULT_SIZE_PER_REDUCER = 0x1000000L;
    private static final int MAX_REDUCERS = 1000;

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_NAME);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            this.parseOptions(options, args);
            Path input = new Path(this.getOptionValue(OPTION_INPUT_PATH));
            Path output = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME).toUpperCase(Locale.ROOT);
            String segmentName = this.getOptionValue(OPTION_SEGMENT_NAME);
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            CubeManager cubeMgr = CubeManager.getInstance(kylinConfig);
            CubeInstance cube = cubeMgr.getCube(cubeName);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            this.setJobClasspath(this.job, cube.getConfig());
            FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{input});
            FileOutputFormat.setOutputPath((Job)this.job, (Path)output);
            this.job.setMapperClass(ColumnToRowMapper.class);
            this.job.setInputFormatClass(ColumnarSplitDataInputFormat.class);
            this.job.setMapOutputKeyClass(Text.class);
            this.job.setMapOutputValueClass(Text.class);
            this.job.setReducerClass(ColumnToRowReducer.class);
            this.job.setNumReduceTasks(this.calReducerNum(input));
            this.job.setOutputFormatClass(SequenceFileOutputFormat.class);
            this.job.setOutputKeyClass(Text.class);
            this.job.setOutputValueClass(Text.class);
            this.job.getConfiguration().set("dfs.block.size", cube.getConfig().getStreamingBasicCuboidJobDFSBlockSize());
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.name", segmentName);
            CubeSegment segment = cube.getSegment(segmentName, SegmentStatusEnum.NEW);
            this.attachSegmentMetadataWithDict(segment, this.job.getConfiguration());
            this.deletePath(this.job.getConfiguration(), output);
            int n = this.waitForCompletion(this.job);
            return n;
        }
        catch (Exception e) {
            logger.error("error in CuboidJob", e);
            this.printUsage(options);
            throw e;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private int calReducerNum(Path input) {
        try {
            long bytesPerReducer = 0x1000000L;
            FileSystem fs = FileSystem.get((Configuration)this.job.getConfiguration());
            ContentSummary cs = fs.getContentSummary(input);
            long totalInputFileSize = cs.getLength();
            int reducers = (int)((totalInputFileSize + bytesPerReducer - 1L) / bytesPerReducer);
            reducers = Math.max(1, reducers);
            reducers = Math.min(1000, reducers);
            logger.info("BytesPerReducer={}, maxReducers={}, totalInputFileSize={}, setReducers={}", bytesPerReducer, 1000, totalInputFileSize, reducers);
            return reducers;
        }
        catch (IOException e) {
            logger.error("error when calculate reducer number", e);
            return 1;
        }
    }

    public static void main(String[] args) throws Exception {
        ColumnToRowJob job = new ColumnToRowJob();
        int exitCode = ToolRunner.run((Tool)job, (String[])args);
        System.exit(exitCode);
    }
}

