/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkSqlBatch
extends AbstractApplication
implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(SparkSqlBatch.class);
    private Options options = new Options();
    public static final Option OPTION_CUBE_NAME;
    public static final Option OPTION_STEP_NAME;
    public static final Option OPTION_SEGMENT_ID;
    public static final Option OPTION_SQL_COUNT;

    public SparkSqlBatch() {
        this.options.addOption(OPTION_CUBE_NAME);
        this.options.addOption(OPTION_STEP_NAME);
        this.options.addOption(OPTION_SEGMENT_ID);
        this.options.addOption(OPTION_SQL_COUNT);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String cubeName = optionsHelper.getOptionValue(OPTION_CUBE_NAME);
        String stepName = this.base64Decode(optionsHelper.getOptionValue(OPTION_STEP_NAME));
        String segmentId = optionsHelper.getOptionValue(OPTION_SEGMENT_ID);
        String sqlCountStr = optionsHelper.getOptionValue(OPTION_SQL_COUNT);
        this.logger.info("start execute sql batch job, cubeName: " + cubeName + ", stepName: " + stepName + ", segmentId: " + segmentId + ", sqlCount: " + sqlCountStr);
        int sqlCount = Integer.valueOf(sqlCountStr);
        if (sqlCount <= 0) {
            throw new RuntimeException("Count of sqls to execute must be greater than 0, in fact is " + sqlCountStr);
        }
        SparkSession sparkSession = this.getSparkSession(stepName + " for cube: " + cubeName + ", segment " + segmentId);
        for (int i = 0; i < sqlCount; ++i) {
            String argName = "base64EncodedSql" + String.valueOf(i);
            OptionBuilder.withArgName((String)argName);
            OptionBuilder.hasArg();
            OptionBuilder.isRequired((boolean)true);
            Option optionSqlText = OptionBuilder.create((String)argName);
            String encodedSql = optionsHelper.getOptionValue(optionSqlText);
            String sqlText = this.base64Decode(encodedSql).trim();
            if (null != sqlText && sqlText.endsWith(";")) {
                sqlText = sqlText.substring(0, sqlText.length() - 1);
            }
            this.logger.info("execute spark sql: " + sqlText);
            if (i == sqlCount - 1) {
                sparkSession.sql(sqlText).count();
                continue;
            }
            sparkSession.sql(sqlText);
        }
    }

    private SparkSession getSparkSession(String appName) {
        return SparkSession.builder().appName(appName).enableHiveSupport().getOrCreate();
    }

    private String base64Decode(String str) throws UnsupportedEncodingException {
        return new String(Base64.getDecoder().decode(str.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    static {
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Name");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"base64StepName");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Step Name");
        OPTION_STEP_NAME = OptionBuilder.create((String)"base64StepName");
        OptionBuilder.withArgName((String)"segmentId");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Segment Id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentId");
        OptionBuilder.withArgName((String)"sqlCount");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Sql count");
        OPTION_SQL_COUNT = OptionBuilder.create((String)"sqlCount");
    }
}

