/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.basic;

import java.math.BigDecimal;
import org.apache.kylin.measure.MeasureAggregator;

public class BigDecimalSumAggregator
extends MeasureAggregator<BigDecimal> {
    BigDecimal sum = null;

    @Override
    public void reset() {
        this.sum = null;
    }

    @Override
    public void aggregate(BigDecimal value) {
        if (value == null) {
            return;
        }
        if (this.sum == null) {
            this.sum = new BigDecimal(0);
        }
        this.sum = this.sum.add(value);
    }

    @Override
    public BigDecimal aggregate(BigDecimal value1, BigDecimal value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        return value1.add(value2);
    }

    @Override
    public BigDecimal getState() {
        return this.sum;
    }

    @Override
    public int getMemBytesEstimate() {
        return BigDecimalSumAggregator.guessBigDecimalMemBytes();
    }
}

