/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.adhoc;

import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.query.adhoc.JdbcPushDownConnectionManager;
import org.apache.kylin.source.adhocquery.AbstractPushdownRunner;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;

public class PushDownRunnerJdbcImpl
extends AbstractPushdownRunner {
    private JdbcPushDownConnectionManager manager = null;
    private static final Map<String, Integer> SQL_TYPE_MAPPING = Maps.newConcurrentMap();

    @Override
    public void init(KylinConfig config) {
        try {
            this.manager = JdbcPushDownConnectionManager.getConnectionManager(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void initById(KylinConfig config, String id) {
        try {
            this.manager = JdbcPushDownConnectionManager.getConnectionManager(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQuery(String query, List<List<String>> results, List<SelectedColumnMeta> columnMetas) throws Exception {
        Statement statement = null;
        Connection connection = this.manager.getConnection();
        ResultSet resultSet = null;
        ResultSetMetaData metaData = null;
        int columnCount = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            this.extractResults(resultSet, results);
            metaData = resultSet.getMetaData();
            columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                SelectedColumnMeta columnMeta = this.extractColumnMeta(metaData, i);
                columnMetas.add(columnMeta);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(resultSet);
            DBUtils.closeQuietly(statement);
            this.manager.close(connection);
            throw throwable;
        }
        DBUtils.closeQuietly(resultSet);
        DBUtils.closeQuietly(statement);
        this.manager.close(connection);
    }

    private SelectedColumnMeta extractColumnMeta(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String tableName;
        String catelogName;
        String schemaName;
        String columnName;
        String columnLabel;
        int columnDisplaySize;
        boolean isSigned;
        int isNullable;
        boolean isCurrency;
        boolean isSearchable;
        boolean isCaseSensitive;
        boolean isAutoIncrement;
        block37: {
            isAutoIncrement = false;
            try {
                isAutoIncrement = resultSetMetaData.isAutoIncrement(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isCaseSensitive = false;
            try {
                isCaseSensitive = resultSetMetaData.isCaseSensitive(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isSearchable = false;
            try {
                isSearchable = resultSetMetaData.isSearchable(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isCurrency = false;
            try {
                isCurrency = resultSetMetaData.isCurrency(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isNullable = 2;
            try {
                isNullable = resultSetMetaData.isNullable(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            isSigned = false;
            try {
                isSigned = resultSetMetaData.isSigned(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            columnDisplaySize = 0;
            try {
                columnDisplaySize = resultSetMetaData.getColumnDisplaySize(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            columnLabel = null;
            try {
                columnLabel = resultSetMetaData.getColumnLabel(columnIndex);
                if (columnLabel.contains(".")) {
                    columnLabel = StringUtils.substringAfterLast(columnLabel, ".").toUpperCase(Locale.ROOT);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            columnName = null;
            try {
                columnName = resultSetMetaData.getColumnName(columnIndex).toUpperCase(Locale.ROOT);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            schemaName = null;
            try {
                schemaName = resultSetMetaData.getSchemaName(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            catelogName = null;
            try {
                catelogName = resultSetMetaData.getCatalogName(columnIndex);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            tableName = null;
            try {
                tableName = resultSetMetaData.getTableName(columnIndex);
            }
            catch (SQLException e) {
                if (!columnLabel.contains(".")) break block37;
                tableName = StringUtils.substringBeforeLast(columnLabel, ".");
            }
        }
        int precision = 0;
        try {
            precision = resultSetMetaData.getPrecision(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        int scale = 0;
        try {
            scale = resultSetMetaData.getScale(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String columnTypeName = null;
        try {
            columnTypeName = resultSetMetaData.getColumnTypeName(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        int columnType = PushDownRunnerJdbcImpl.toSqlType(columnTypeName);
        boolean isReadOnly = false;
        try {
            isReadOnly = resultSetMetaData.isReadOnly(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        boolean isWritable = false;
        try {
            isWritable = resultSetMetaData.isWritable(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        boolean isDefinitelyWritable = false;
        try {
            isDefinitelyWritable = resultSetMetaData.isDefinitelyWritable(columnIndex);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        SelectedColumnMeta columnMeta = new SelectedColumnMeta(isAutoIncrement, isCaseSensitive, isSearchable, isCurrency, isNullable, isSigned, columnDisplaySize, columnLabel, columnName, schemaName, catelogName, tableName, precision, scale, columnType, columnTypeName, isReadOnly, isWritable, isDefinitelyWritable);
        return columnMeta;
    }

    public static int toSqlType(String type) throws SQLException {
        if ((type = type.toLowerCase(Locale.ROOT)).startsWith("decimal")) {
            return 3;
        }
        if (SQL_TYPE_MAPPING.containsKey(type)) {
            return SQL_TYPE_MAPPING.get(type);
        }
        throw new SQLException("Unrecognized column type: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeUpdate(String sql) throws Exception {
        Statement statement = null;
        Connection connection = this.manager.getConnection();
        try {
            statement = connection.createStatement();
            statement.execute(sql);
        }
        finally {
            DBUtils.closeQuietly(statement);
            this.manager.close(connection);
        }
    }

    private void extractResults(ResultSet resultSet, List<List<String>> results) throws SQLException {
        LinkedList<String> oneRow = new LinkedList<String>();
        while (resultSet.next()) {
            for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                oneRow.add(resultSet.getString(i + 1));
            }
            results.add(new LinkedList(oneRow));
            oneRow.clear();
        }
    }

    static {
        SQL_TYPE_MAPPING.put("string", 12);
        SQL_TYPE_MAPPING.put("varchar", 12);
        SQL_TYPE_MAPPING.put("char", 1);
        SQL_TYPE_MAPPING.put("float", 6);
        SQL_TYPE_MAPPING.put("real", 7);
        SQL_TYPE_MAPPING.put("double", 8);
        SQL_TYPE_MAPPING.put("boolean", 16);
        SQL_TYPE_MAPPING.put("tinyint", -6);
        SQL_TYPE_MAPPING.put("smallint", 5);
        SQL_TYPE_MAPPING.put("int", 4);
        SQL_TYPE_MAPPING.put("bigint", -5);
        SQL_TYPE_MAPPING.put("date", 91);
        SQL_TYPE_MAPPING.put("timestamp", 93);
        SQL_TYPE_MAPPING.put("binary", -2);
        SQL_TYPE_MAPPING.put("map", 2000);
        SQL_TYPE_MAPPING.put("array", 2003);
        SQL_TYPE_MAPPING.put("struct", 2002);
        SQL_TYPE_MAPPING.put("integer", 4);
        SQL_TYPE_MAPPING.put("time", 12);
        SQL_TYPE_MAPPING.put("varbinary", -2);
    }
}

