/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.kylin.common.util.CheckUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ModelDimensionDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class ModelSchemaUpdateChecker {
    private final TableMetadataManager metadataManager;
    private final CubeManager cubeManager;
    private final DataModelManager dataModelManager;

    ModelSchemaUpdateChecker(TableMetadataManager metadataManager, CubeManager cubeManager, DataModelManager dataModelManager) {
        this.metadataManager = (TableMetadataManager)Preconditions.checkNotNull((Object)metadataManager, (Object)"metadataManager is null");
        this.cubeManager = (CubeManager)Preconditions.checkNotNull((Object)cubeManager, (Object)"cubeManager is null");
        this.dataModelManager = (DataModelManager)Preconditions.checkNotNull((Object)dataModelManager, (Object)"dataModelManager is null");
    }

    private List<CubeInstance> findCubeByModel(String modelName) {
        Iterable relatedCubes = Iterables.filter(this.cubeManager.listAllCubes(), cube -> {
            if (cube == null || cube.allowBrokenDescriptor()) {
                return false;
            }
            DataModelDesc model = cube.getModel();
            if (model == null) {
                return false;
            }
            return model.getName().equals(modelName);
        });
        return ImmutableList.copyOf((Iterable)relatedCubes);
    }

    private static void checkDataModelCompatible(DataModelDesc existing, DataModelDesc newModel, List<String> issues) {
        if (!existing.getRootFactTableName().equalsIgnoreCase(newModel.getRootFactTableName())) {
            issues.add(String.format(Locale.ROOT, "The fact table %s used in existing model is not the same as the updated one %s", existing.getRootFactTableName(), newModel.getRootFactTableName()));
        }
        HashMap existingLookupMap = Maps.newHashMap();
        for (JoinTableDesc joinTableDesc : existing.getJoinTables()) {
            existingLookupMap.put(joinTableDesc.getAlias(), joinTableDesc);
        }
        for (JoinTableDesc joinTableDesc : newModel.getJoinTables()) {
            if (existingLookupMap.get(joinTableDesc.getAlias()) == null) {
                issues.add(String.format(Locale.ROOT, "The join table %s does not existing in existing model", joinTableDesc.getTable()));
                continue;
            }
            JoinTableDesc existingLookup = (JoinTableDesc)existingLookupMap.remove(joinTableDesc.getAlias());
            if (!existingLookup.getTable().equals(joinTableDesc.getTable())) {
                issues.add(String.format(Locale.ROOT, "The join table %s used in existing model is not the same as the updated one %s", existingLookup.getTable(), joinTableDesc.getTable()));
                continue;
            }
            if (!existingLookup.getKind().equals(joinTableDesc.getKind())) {
                issues.add(String.format(Locale.ROOT, "The TableKind %s in existing model is not the same as the updated one %s for table %s", existingLookup.getKind(), joinTableDesc.getKind(), existingLookup.getTable()));
                continue;
            }
            if (existingLookup.getJoin().equals(joinTableDesc.getJoin())) continue;
            issues.add(String.format(Locale.ROOT, "The join %s is not the same as the existing one %s", joinTableDesc.getJoin(), existingLookup.getJoin()));
        }
        if (existingLookupMap.size() > 0) {
            issues.add(String.format(Locale.ROOT, "Missing lookup tables %s", existingLookupMap.keySet()));
        }
        if (!CheckUtil.equals(existing.getPartitionDesc(), newModel.getPartitionDesc())) {
            issues.add(String.format(Locale.ROOT, "The partition desc %s is not the same as the existing one %s", newModel.getPartitionDesc(), existing.getPartitionDesc()));
        }
        if (!CheckUtil.equals(existing.getFilterCondition(), newModel.getFilterCondition())) {
            issues.add(String.format(Locale.ROOT, "The filter %s is not the same as the existing one %s", newModel.getFilterCondition(), existing.getFilterCondition()));
        }
    }

    public CheckResult allowEdit(DataModelDesc modelDesc, String prj) {
        return this.allowEdit(modelDesc, prj, !modelDesc.isDraft());
    }

    public CheckResult allowEdit(DataModelDesc modelDesc, String prj, boolean needInit) {
        List<CubeInstance> cubes;
        String modelName = modelDesc.getName();
        DataModelDesc existing = this.dataModelManager.getDataModelDesc(modelName);
        if (existing == null) {
            return CheckResult.validOnFirstCreate(modelName);
        }
        if (needInit) {
            modelDesc.init(this.metadataManager.getConfig(), this.metadataManager.getAllTablesMap(prj));
        }
        if ((cubes = this.findCubeByModel(modelName)).size() <= 0) {
            return CheckResult.validOnCompatibleSchema(modelName);
        }
        existing = cubes.get(0).getModel();
        ArrayList issues = Lists.newArrayList();
        ModelSchemaUpdateChecker.checkDataModelCompatible(existing, modelDesc, issues);
        if (!issues.isEmpty()) {
            return CheckResult.invalidOnIncompatibleSchema(modelName, issues);
        }
        HashSet dimensionColumns = Sets.newHashSet();
        for (ModelDimensionDesc modelDimensionDesc : modelDesc.getDimensions()) {
            for (String columnName : modelDimensionDesc.getColumns()) {
                dimensionColumns.add(modelDimensionDesc.getTable() + "." + columnName);
            }
        }
        for (JoinTableDesc joinTableDesc : modelDesc.getJoinTables()) {
            ArrayList keyCols = Lists.newArrayList((Object[])joinTableDesc.getJoin().getForeignKeyColumns());
            keyCols.addAll(Lists.newArrayList((Object[])joinTableDesc.getJoin().getPrimaryKeyColumns()));
            dimensionColumns.addAll(Lists.transform((List)keyCols, entry -> entry.getIdentity()));
        }
        HashSet measureColumns = Sets.newHashSet((Object[])modelDesc.getMetrics());
        for (CubeInstance cube : cubes) {
            List cubeMeasureTblColRefLists;
            List cubeMeasureColumns;
            LinkedList cubeDimensionColumns = Lists.newLinkedList();
            for (TblColRef entry2 : cube.getAllDimensions()) {
                cubeDimensionColumns.add(entry2.getIdentity());
            }
            for (MeasureDesc input : cube.getMeasures()) {
                FunctionDesc funcDesc = input.getFunction();
                if (!"TOP_N".equalsIgnoreCase(funcDesc.getExpression())) continue;
                List<TblColRef> ret = funcDesc.getParameter().getColRefs();
                cubeDimensionColumns.addAll(Lists.transform(ret.subList(1, ret.size()), entry -> entry.getIdentity()));
            }
            if (!dimensionColumns.containsAll(cubeDimensionColumns)) {
                cubeDimensionColumns.removeAll(dimensionColumns);
                issues.add(String.format(Locale.ROOT, "Missing some dimension columns %s for cube %s", cubeDimensionColumns, cube.getName()));
            }
            if (measureColumns.containsAll(cubeMeasureColumns = Lists.transform((List)Lists.newArrayList((Iterable)Iterables.concat((Iterable)(cubeMeasureTblColRefLists = Lists.transform(cube.getMeasures(), entry -> {
                FunctionDesc funcDesc = entry.getFunction();
                List<TblColRef> ret = funcDesc.getParameter().getColRefs();
                if ("TOP_N".equalsIgnoreCase(funcDesc.getExpression())) {
                    return Lists.newArrayList((Object[])new TblColRef[]{ret.get(0)});
                }
                return funcDesc.getParameter().getColRefs();
            })))), entry -> entry.getIdentity()))) continue;
            cubeMeasureColumns.removeAll(measureColumns);
            issues.add(String.format(Locale.ROOT, "Missing some measure columns %s for cube %s", cubeMeasureColumns, cube.getName()));
        }
        if (issues.isEmpty()) {
            return CheckResult.validOnCompatibleSchema(modelName);
        }
        return CheckResult.invalidOnIncompatibleSchema(modelName, issues);
    }

    static class CheckResult {
        private final boolean valid;
        private final String reason;

        private CheckResult(boolean valid, String reason) {
            this.valid = valid;
            this.reason = reason;
        }

        void raiseExceptionWhenInvalid() {
            if (!this.valid) {
                throw new RuntimeException(this.reason);
            }
        }

        static CheckResult validOnFirstCreate(String modelName) {
            return new CheckResult(true, String.format(Locale.ROOT, "Model '%s' hasn't been created before", modelName));
        }

        static CheckResult validOnCompatibleSchema(String modelName) {
            return new CheckResult(true, String.format(Locale.ROOT, "Table '%s' is compatible with all existing cubes", modelName));
        }

        static CheckResult invalidOnIncompatibleSchema(String modelName, List<String> reasons) {
            StringBuilder buf = new StringBuilder();
            for (String reason : reasons) {
                buf.append("- ").append(reason).append("\n");
            }
            return new CheckResult(false, String.format(Locale.ROOT, "Found %d issue(s) with '%s':%n%s Please disable and purge related cube(s) first", reasons.size(), modelName, buf.toString()));
        }
    }
}

