/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service.update;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.SnapshotTableDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.rest.service.update.TableSchemaUpdateMapping;

public class TableSchemaUpdater {
    public static TableDesc dealWithMappingForTable(TableDesc other, Map<String, TableSchemaUpdateMapping> mappings) {
        TableSchemaUpdateMapping mapping = TableSchemaUpdater.getTableSchemaUpdateMapping(mappings, other.getIdentity());
        if (mapping == null) {
            return other;
        }
        TableDesc copy = new TableDesc(other);
        copy.setDatabase(mapping.getDatabase(other.getDatabase()));
        copy.setName(mapping.getTableName(other.getName()));
        copy.setLastModified(0L);
        return copy;
    }

    public static DataModelDesc dealWithMappingForModel(DataModelDesc other, Map<String, TableSchemaUpdateMapping> mappings) {
        if (!Strings.isNullOrEmpty((String)other.getFilterCondition())) {
            throw new UnsupportedOperationException("Cannot deal with filter condition " + other.getFilterCondition());
        }
        DataModelDesc copy = DataModelDesc.getCopyOf(other);
        copy.setLastModified(other.getLastModified());
        TableSchemaUpdateMapping rootMapping = TableSchemaUpdater.getTableSchemaUpdateMapping(mappings, other.getRootFactTableName());
        if (rootMapping != null) {
            TableDesc rootFactTable = other.getRootFactTable().getTableDesc();
            copy.setRootFactTableName(rootMapping.getTableIdentity(rootFactTable.getDatabase(), rootFactTable.getName()));
        }
        JoinTableDesc[] joinTables = other.getJoinTables();
        JoinTableDesc[] joinTablesCopy = new JoinTableDesc[joinTables.length];
        for (int i = 0; i < joinTables.length; ++i) {
            JoinTableDesc joinTable = joinTables[i];
            joinTablesCopy[i] = JoinTableDesc.getCopyOf(joinTable);
            String tableIdentity = joinTable.getTable();
            TableSchemaUpdateMapping mapping = TableSchemaUpdater.getTableSchemaUpdateMapping(mappings, tableIdentity);
            if (mapping == null || !mapping.isTableIdentityChanged()) continue;
            joinTablesCopy[i].setTable(mapping.getTableIdentity(tableIdentity));
        }
        copy.setJoinTables(joinTablesCopy);
        PartitionDesc partDesc = other.getPartitionDesc();
        PartitionDesc partCopy = PartitionDesc.getCopyOf(partDesc);
        if (partDesc.getPartitionDateColumnRef() != null) {
            partCopy.setPartitionDateColumn(TableSchemaUpdater.replacePartitionCol(partDesc.getPartitionDateColumnRef().getCanonicalName(), mappings));
        }
        if (partDesc.getPartitionTimeColumnRef() != null) {
            partCopy.setPartitionTimeColumn(TableSchemaUpdater.replacePartitionCol(partDesc.getPartitionTimeColumnRef().getCanonicalName(), mappings));
        }
        copy.setPartitionDesc(partCopy);
        return copy;
    }

    public static CubeDesc dealWithMappingForCubeDesc(CubeDesc other, Map<String, TableSchemaUpdateMapping> mappings) {
        CubeDesc copy = CubeDesc.getCopyOf(other);
        copy.setLastModified(other.getLastModified());
        if (other.getSnapshotTableDescList() != null && !other.getSnapshotTableDescList().isEmpty()) {
            ArrayList snapshotTableDescListCopy = Lists.newArrayListWithExpectedSize((int)other.getSnapshotTableDescList().size());
            for (SnapshotTableDesc snapshotDesc : other.getSnapshotTableDescList()) {
                TableSchemaUpdateMapping mapping = TableSchemaUpdater.getTableSchemaUpdateMapping(mappings, snapshotDesc.getTableName());
                if (mapping != null && mapping.isTableIdentityChanged()) {
                    snapshotDesc = SnapshotTableDesc.getCopyOf(snapshotDesc);
                    snapshotDesc.setTableName(mapping.getTableIdentity(snapshotDesc.getTableName()));
                }
                snapshotTableDescListCopy.add(snapshotDesc);
            }
            copy.setSnapshotTableDescList(snapshotTableDescListCopy);
        }
        return copy;
    }

    public static CubeInstance dealWithMappingForCube(CubeInstance other, Map<String, TableSchemaUpdateMapping> mappings) {
        CubeInstance copy = CubeInstance.getCopyOf(other);
        copy.setLastModified(other.getLastModified());
        if (other.getSnapshots() != null && !other.getSnapshots().isEmpty()) {
            Map<String, String> snapshotsCopy = TableSchemaUpdater.replaceTableIdentityForTableSnapshots(other.getSnapshots(), mappings);
            copy.resetSnapshots();
            copy.getSnapshots().putAll(snapshotsCopy);
        }
        if (other.getSegments() != null && !other.getSegments().isEmpty()) {
            Segments segmentsCopy = new Segments();
            for (CubeSegment segment : other.getSegments()) {
                CubeSegment segmentCopy = CubeSegment.getCopyOf(segment);
                segmentCopy.setCubeInstance(copy);
                Map<String, String> snapshotsCopy = TableSchemaUpdater.replaceTableIdentityForTableSnapshots(segment.getSnapshots(), mappings);
                segmentCopy.resetSnapshots();
                segmentCopy.getSnapshots().putAll(snapshotsCopy);
                segmentsCopy.add(segmentCopy);
            }
            copy.setSegments(segmentsCopy);
        }
        return copy;
    }

    private static Map<String, String> replaceTableIdentityForTableSnapshots(Map<String, String> snapshots, Map<String, TableSchemaUpdateMapping> mappings) {
        HashMap snapshotsCopy = Maps.newHashMapWithExpectedSize((int)snapshots.size());
        for (String tableIdentity : snapshots.keySet()) {
            String resPath = snapshots.get(tableIdentity);
            TableSchemaUpdateMapping mapping = TableSchemaUpdater.getTableSchemaUpdateMapping(mappings, tableIdentity);
            if (mapping != null && mapping.isTableIdentityChanged()) {
                tableIdentity = mapping.getTableIdentity(tableIdentity);
            }
            snapshotsCopy.put(tableIdentity, resPath);
        }
        return snapshotsCopy;
    }

    private static String replacePartitionCol(String partCol, Map<String, TableSchemaUpdateMapping> mappings) {
        int cut = partCol.lastIndexOf(46);
        if (cut < 0) {
            return partCol;
        }
        String partTableIdentity = partCol.substring(0, cut);
        TableSchemaUpdateMapping mapping = TableSchemaUpdater.getTableSchemaUpdateMapping(mappings, partTableIdentity);
        if (mapping != null) {
            return mapping.getTableIdentity(partTableIdentity) + "." + partCol.substring(cut + 1);
        }
        return partCol;
    }

    public static TableSchemaUpdateMapping getTableSchemaUpdateMapping(Map<String, TableSchemaUpdateMapping> mappings, String key) {
        return mappings.get(key.toUpperCase(Locale.ROOT));
    }
}

