/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.engine.mr.DFSFileTable;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.hive.HiveClientFactory;
import org.apache.kylin.source.hive.HiveTableMeta;
import org.apache.kylin.source.hive.HiveTableReader;
import org.apache.kylin.source.hive.IHiveClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTable
implements IReadableTable {
    private static final Logger logger = LoggerFactory.getLogger(HiveTable.class);
    private final String database;
    private final String hiveTable;
    private IHiveClient hiveClient;
    private HiveTableMeta hiveTableMeta;

    public HiveTable(TableDesc tableDesc) {
        this.database = tableDesc.getDatabase();
        this.hiveTable = tableDesc.getName();
        try {
            this.hiveTableMeta = this.getHiveClient().getHiveTableMeta(this.database, this.hiveTable);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot get HiveTableMeta", e);
        }
    }

    @Override
    public IReadableTable.TableReader getReader() throws IOException {
        return new HiveTableReader(this.database, this.hiveTable);
    }

    @Override
    public IReadableTable.TableSignature getSignature() throws IOException {
        try {
            String path = this.computeHDFSLocation();
            Pair<Long, Long> sizeAndLastModified = DFSFileTable.getSizeAndLastModified(path);
            long size = sizeAndLastModified.getFirst();
            long lastModified = sizeAndLastModified.getSecond();
            if (!this.hiveTableMeta.isNative) {
                lastModified = System.currentTimeMillis();
            }
            return new IReadableTable.TableSignature(path, size, lastModified);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    @Override
    public boolean exists() {
        return true;
    }

    private String computeHDFSLocation() throws Exception {
        String override = KylinConfig.getInstanceFromEnv().getOverrideHiveTableLocation(this.hiveTable);
        if (override != null) {
            logger.debug("Override hive table location " + this.hiveTable + " -- " + override);
            return override;
        }
        return this.hiveTableMeta.sdLocation;
    }

    public IHiveClient getHiveClient() {
        if (this.hiveClient == null) {
            this.hiveClient = HiveClientFactory.getHiveClient();
        }
        return this.hiveClient;
    }

    public String toString() {
        return "hive: database=[" + this.database + "], table=[" + this.hiveTable + "]";
    }
}

