/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.util.List;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.engine.spark.ISparkOutput;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.storage.hbase.steps.HBaseSparkSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSparkOutputTransition
implements ISparkOutput {
    private static final Logger logger = LoggerFactory.getLogger(HBaseSparkOutputTransition.class);

    @Override
    public ISparkOutput.ISparkBatchCubingOutputSide getBatchCubingOutputSide(final CubeSegment seg) {
        final HBaseSparkSteps steps = new HBaseSparkSteps(seg);
        return new ISparkOutput.ISparkBatchCubingOutputSide(){

            @Override
            public void addStepPhase2_BuildDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(steps.createCreateHTableStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                if (seg.getConfig().isHFileDistCP()) {
                    jobFlow.addTask(steps.createDistcpHFileStep(jobFlow.getId()));
                }
                jobFlow.addTask(steps.createBulkLoadStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
                steps.addCubingGarbageCollectionSteps(jobFlow);
            }
        };
    }

    @Override
    public ISparkOutput.ISparkBatchMergeOutputSide getBatchMergeOutputSide(final CubeSegment seg) {
        return new ISparkOutput.ISparkBatchMergeOutputSide(){
            HBaseSparkSteps steps;
            {
                this.steps = new HBaseSparkSteps(seg);
            }

            @Override
            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createCreateHTableStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase2_BuildCube(CubeSegment seg2, List<CubeSegment> mergingSegments, DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                if (seg2.getConfig().isHFileDistCP()) {
                    jobFlow.addTask(this.steps.createDistcpHFileStep(jobFlow.getId()));
                }
                jobFlow.addTask(this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase3_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addMergingGarbageCollectionSteps(jobFlow);
            }
        };
    }

    @Override
    public ISparkOutput.ISparkBatchOptimizeOutputSide getBatchOptimizeOutputSide(final CubeSegment seg) {
        return new ISparkOutput.ISparkBatchOptimizeOutputSide(){
            HBaseSparkSteps steps;
            {
                this.steps = new HBaseSparkSteps(seg);
            }

            @Override
            public void addStepPhase2_CreateHTable(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createCreateHTableStep(jobFlow.getId(), CuboidModeEnum.RECOMMEND));
            }

            @Override
            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask(this.steps.createConvertCuboidToHfileStep(jobFlow.getId()));
                jobFlow.addTask(this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            @Override
            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addOptimizeGarbageCollectionSteps(jobFlow);
            }

            @Override
            public void addStepPhase5_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addCheckpointGarbageCollectionSteps(jobFlow);
            }
        };
    }
}

