/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.dict;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kylin.common.Closeable;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.stream.core.dict.LocalDictionaryStore;
import org.apache.kylin.stream.core.dict.RemoteDictionaryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingDictionaryClient
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(StreamingDictionaryClient.class);
    private static final ByteArray defaultCf = new ByteArray("default".getBytes(StandardCharsets.UTF_8));
    private static final String GLOBAL_START_ID = "GLOBAL_START_ID";
    public static final String MSG_TEMPLATE = "Dictionary Client Info:  ExceptionLocal:%9d,  ExceptionRemote:%9d, HitLocal:%9d,  MissLocal:%9d,  ALL:%9d .";
    public static final int DICT_ID_RANGE_LEN = 30000;
    public static final int ID_UNKNOWN = -2;
    public static final int ID_FOR_EXCEPTION = -1;
    public static final int ID_FOR_EMPTY_STR = 0;
    public static final int MIN_ID_FOR_NO_EMPTY_STR = 1;
    public static final int MAX_ID_FOR_NO_EMPTY_STR = 2147453637;
    private int startDictId = -1;
    private int offset = 0;
    private AtomicLong encodeCounter = new AtomicLong();
    private AtomicLong hitLocal = new AtomicLong();
    private AtomicLong missLocal = new AtomicLong();
    private AtomicLong errorLocal = new AtomicLong();
    private AtomicLong errorRemote = new AtomicLong();
    private long lastCheck = System.currentTimeMillis();
    private long lastTotalError = 0L;
    private LocalDictionaryStore localStore;
    private RemoteDictionaryStore remoteStore;

    public StreamingDictionaryClient(String cubeName, String[] columns) {
        String[] columnFamily = this.getCf(columns);
        try {
            this.localStore = new LocalDictionaryStore(cubeName);
            this.remoteStore = new RemoteDictionaryStore(cubeName);
            this.remoteStore.init(columnFamily);
            this.localStore.init(columnFamily);
        }
        catch (Exception e) {
            throw new RuntimeException("Init dictionary failed.", e);
        }
    }

    public int encode(ByteArray column, String value) {
        this.checkDictIdRange();
        this.printStat();
        int localId = this.localStore.encode(column, value);
        int expected = this.startDictId + this.offset;
        if (localId >= 0) {
            this.hitLocal.addAndGet(1L);
            return localId;
        }
        if (localId == -1) {
            this.errorLocal.addAndGet(1L);
        } else {
            this.missLocal.addAndGet(1L);
        }
        int remoteId = this.remoteStore.checkAndPutWithRetry(column, value, -2, expected, false);
        if (remoteId == -1) {
            this.errorRemote.addAndGet(1L);
            return 1;
        }
        if (remoteId == -2) {
            remoteId = this.remoteStore.encodeWithRetry(column, value);
        } else {
            ++this.offset;
        }
        if (remoteId > 0 && !this.localStore.put(column, value, remoteId)) {
            this.errorLocal.addAndGet(1L);
        }
        return remoteId;
    }

    void checkDictIdRange() {
        if (this.startDictId == -1) {
            logger.debug("Init dict range.");
            int res = this.remoteStore.checkAndPutWithRetry(defaultCf, GLOBAL_START_ID, 1, 1, false);
            if (res != -2) {
                logger.debug("First dictId in global.");
                this.startDictId = 1;
            } else {
                this.startDictId = this.findStartId();
                logger.debug("After allcated, current startDictId is {}.", (Object)this.startDictId);
            }
        }
        if (this.offset >= 29999) {
            logger.debug("Ask for another dictId range. Current startDictId is {}.", (Object)this.startDictId);
            this.startDictId = this.findStartId();
            logger.debug("After allcated, current startDictId is {}.", (Object)this.startDictId);
            this.offset = 0;
        }
        if (this.startDictId >= 2147453637) {
            // empty if block
        }
    }

    int findStartId() {
        int finalV = -2;
        int oldV = this.remoteStore.encodeWithRetry(defaultCf, GLOBAL_START_ID);
        boolean hasPut = false;
        while (!hasPut) {
            int res = this.remoteStore.checkAndPutWithRetry(defaultCf, GLOBAL_START_ID, oldV, oldV + 30000, true);
            if (res == -2) {
                oldV = this.remoteStore.encodeWithRetry(defaultCf, GLOBAL_START_ID);
                continue;
            }
            finalV = res;
            hasPut = true;
        }
        return finalV;
    }

    private String[] getCf(String[] columns) {
        String[] cfs = new String[columns.length + 1];
        cfs[0] = "default";
        int idx = 1;
        for (String col : columns) {
            cfs[idx++] = col;
        }
        return cfs;
    }

    private void printStat() {
        long curr = this.encodeCounter.addAndGet(1L);
        if (System.currentTimeMillis() - this.lastCheck >= 10000L) {
            long totalError = this.errorRemote.get() + this.errorLocal.get();
            String msg = String.format(Locale.ROOT, MSG_TEMPLATE, this.errorLocal.get(), this.errorRemote.get(), this.hitLocal.get(), this.missLocal.get(), curr);
            if (totalError > this.lastTotalError) {
                logger.warn("Exception in dict\n {}", (Object)msg);
                this.lastTotalError = totalError;
            } else {
                logger.info(msg);
            }
            this.lastCheck = System.currentTimeMillis();
        }
    }

    @Override
    public void close() {
        this.localStore.close();
    }
}

