/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.model;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.source.Partition;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CubeAssignment {
    @JsonProperty(value="cube_name")
    private String cubeName;
    @JsonProperty(value="assignments")
    private Map<Integer, List<Partition>> assignments;
    private Map<Integer, Integer> partitionReplicaSetIDMap;

    @JsonCreator
    public CubeAssignment(@JsonProperty(value="cube_name") String cubeName, @JsonProperty(value="assignments") Map<Integer, List<Partition>> assignments) {
        this.cubeName = cubeName;
        this.assignments = assignments;
        this.partitionReplicaSetIDMap = Maps.newHashMap();
        for (Map.Entry<Integer, List<Partition>> assignEntry : assignments.entrySet()) {
            for (Partition partition : assignEntry.getValue()) {
                this.partitionReplicaSetIDMap.put(partition.getPartitionId(), assignEntry.getKey());
            }
        }
    }

    public static byte[] serializeCubeAssignment(CubeAssignment cubeAssignment) throws IOException {
        return JsonUtil.writeValueAsBytes(cubeAssignment);
    }

    public static CubeAssignment deserializeCubeAssignment(byte[] assignmentData) throws IOException {
        return JsonUtil.readValue(assignmentData, CubeAssignment.class);
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public Map<Integer, List<Partition>> getAssignments() {
        return this.assignments;
    }

    public Set<Integer> getReplicaSetIDs() {
        return this.assignments.keySet();
    }

    public Set<Integer> getPartitionIDs() {
        return this.partitionReplicaSetIDMap.keySet();
    }

    public List<Partition> getPartitionsByReplicaSetID(Integer replicaSetID) {
        List<Partition> result = this.assignments.get(replicaSetID);
        if (result == null) {
            result = Lists.newArrayList();
        }
        return result;
    }

    public void addAssignment(Integer replicaSetID, List<Partition> partitions) {
        this.assignments.put(replicaSetID, partitions);
    }

    public void removeAssignment(Integer replicaSetID) {
        this.assignments.remove(replicaSetID);
    }

    public Integer getReplicaSetIDByPartition(Integer partitionID) {
        return this.partitionReplicaSetIDMap.get(partitionID);
    }

    public Integer getPartitionNum() {
        return this.partitionReplicaSetIDMap.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assignments == null ? 0 : this.assignments.hashCode());
        result = 31 * result + (this.cubeName == null ? 0 : this.cubeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CubeAssignment other = (CubeAssignment)obj;
        if (this.assignments == null ? other.assignments != null : !this.assignments.equals(other.assignments)) {
            return false;
        }
        return !(this.cubeName == null ? other.cubeName != null : !this.cubeName.equals(other.cubeName));
    }

    public String toString() {
        return "CubeAssignment [cubeName=" + this.cubeName + ", assignments=" + this.assignments + "]";
    }
}

