/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.io.IOException;
import java.util.List;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.query.IStreamingSearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultCollector
implements IStreamingSearchResult {
    private static Logger logger = LoggerFactory.getLogger(ResultCollector.class);
    protected List<IStreamingSearchResult> searchResults = Lists.newArrayList();
    private List<CloseListener> closeListeners = Lists.newArrayList();

    public void collectSearchResult(IStreamingSearchResult searchResult) {
        this.searchResults.add(searchResult);
    }

    public void addCloseListener(CloseListener listener) {
        this.closeListeners.add(listener);
    }

    @Override
    public void close() throws IOException {
        Exception oneException = null;
        for (CloseListener listener : this.closeListeners) {
            try {
                listener.onClose();
            }
            catch (Exception e) {
                logger.error("exception throws when on close is called", e);
            }
        }
        for (IStreamingSearchResult input : this.searchResults) {
            try {
                input.close();
            }
            catch (Exception e) {
                oneException = e;
            }
        }
        if (oneException != null) {
            if (oneException instanceof IOException) {
                throw (IOException)oneException;
            }
            throw new IOException(oneException);
        }
    }

    @Override
    public void startRead() {
    }

    @Override
    public void endRead() {
    }

    public static interface CloseListener {
        public void onClose();
    }
}

