/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.datatype.DoubleSerializer;
import org.apache.kylin.metadata.datatype.Long8Serializer;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncoding;

public class ColumnarMetricsEncodingFactory {
    private static Set<String> longEncodingTypes = Sets.newHashSet();
    private static Set<String> doubleEncodingTypes = Sets.newHashSet();

    public static ColumnarMetricsEncoding create(DataType dataType) {
        if (longEncodingTypes.contains(dataType.getName())) {
            return new ColumnarLongMetricsEncoding(dataType);
        }
        if (doubleEncodingTypes.contains(dataType.getName())) {
            return new ColumnarDoubleMetricsEncoding(dataType);
        }
        return new ColumnarComplexMetricsEncoding(dataType);
    }

    static {
        longEncodingTypes.add("bigint");
        longEncodingTypes.add("long");
        longEncodingTypes.add("integer");
        longEncodingTypes.add("int");
        longEncodingTypes.add("tinyint");
        longEncodingTypes.add("smallint");
        doubleEncodingTypes.add("double");
        doubleEncodingTypes.add("float");
    }

    public static class ColumnarComplexMetricsEncoding
    extends ColumnarMetricsEncoding {
        public ColumnarComplexMetricsEncoding(DataType dataType) {
            super(dataType);
        }

        @Override
        public boolean isFixLength() {
            return false;
        }

        @Override
        public int getFixLength() {
            return -1;
        }

        public DataTypeSerializer asDataTypeSerializer() {
            return DataTypeSerializer.create(this.dataType);
        }
    }

    public static class ColumnarDoubleMetricsEncoding
    extends ColumnarMetricsEncoding<Double> {
        public ColumnarDoubleMetricsEncoding(DataType dataType) {
            super(dataType);
        }

        @Override
        public boolean isFixLength() {
            return true;
        }

        @Override
        public int getFixLength() {
            return 8;
        }

        @Override
        public DataTypeSerializer<Double> asDataTypeSerializer() {
            return new DoubleSerializer(this.dataType);
        }
    }

    public static class ColumnarFixLenLongMetricsEncoding
    extends ColumnarMetricsEncoding<Long> {
        private int fixLength;

        public ColumnarFixLenLongMetricsEncoding(DataType dataType, int fixLength) {
            super(dataType);
            this.fixLength = fixLength;
        }

        @Override
        public boolean isFixLength() {
            return true;
        }

        @Override
        public int getFixLength() {
            return this.fixLength;
        }

        @Override
        public DataTypeSerializer<Long> asDataTypeSerializer() {
            return new DataTypeSerializer<Long>(){

                @Override
                public int peekLength(ByteBuffer in) {
                    return fixLength;
                }

                @Override
                public int maxLength() {
                    return fixLength;
                }

                @Override
                public int getStorageBytesEstimate() {
                    return fixLength;
                }

                @Override
                public void serialize(Long value, ByteBuffer out) {
                    long longV = value;
                    for (int i = 0; i < fixLength; ++i) {
                        out.put((byte)longV);
                        longV >>>= 8;
                    }
                }

                @Override
                public Long deserialize(ByteBuffer in) {
                    long integer = 0L;
                    int mask = 255;
                    int shift = 0;
                    for (int i = 0; i < fixLength; ++i) {
                        integer |= (long)(in.get() << shift & mask);
                        mask <<= 8;
                        shift += 8;
                    }
                    return integer;
                }
            };
        }
    }

    public static class ColumnarLongMetricsEncoding
    extends ColumnarMetricsEncoding<Long> {
        public ColumnarLongMetricsEncoding(DataType dataType) {
            super(dataType);
        }

        @Override
        public boolean isFixLength() {
            return true;
        }

        @Override
        public int getFixLength() {
            return 8;
        }

        @Override
        public DataTypeSerializer<Long> asDataTypeSerializer() {
            return new Long8Serializer(this.dataType);
        }
    }
}

