/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Charsets;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.shaded.com.google.common.io.Files;
import org.apache.kylin.stream.core.exception.IllegalStorageException;
import org.apache.kylin.stream.core.metrics.StreamingMetrics;
import org.apache.kylin.stream.core.model.StreamingMessage;
import org.apache.kylin.stream.core.model.stats.SegmentStoreStats;
import org.apache.kylin.stream.core.query.ResultCollector;
import org.apache.kylin.stream.core.query.StreamingSearchContext;
import org.apache.kylin.stream.core.storage.IStreamingSegmentStore;
import org.apache.kylin.stream.core.storage.StreamingCubeSegment;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMemoryStorePersister;
import org.apache.kylin.stream.core.storage.columnar.ColumnarSegmentStoreFilesSearcher;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreCache;
import org.apache.kylin.stream.core.storage.columnar.DataSegmentFragment;
import org.apache.kylin.stream.core.storage.columnar.FragmentFilesMerger;
import org.apache.kylin.stream.core.storage.columnar.FragmentId;
import org.apache.kylin.stream.core.storage.columnar.FragmentsMergeResult;
import org.apache.kylin.stream.core.storage.columnar.ParsedStreamingCubeInfo;
import org.apache.kylin.stream.core.storage.columnar.SegmentMemoryStore;
import org.apache.kylin.stream.core.util.NamedThreadFactory;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnarSegmentStore
implements IStreamingSegmentStore {
    private static final String STATE_FILE = "_STATE";
    private static Logger logger = LoggerFactory.getLogger(ColumnarSegmentStore.class);
    private static ExecutorService fragmentMergeExecutor;
    private volatile SegmentMemoryStore activeMemoryStore;
    private volatile SegmentMemoryStore persistingMemoryStore;
    private ReentrantReadWriteLock persistLock;
    private ReentrantReadWriteLock.ReadLock persistReadLock;
    private ReentrantReadWriteLock.WriteLock persistWriteLock;
    private ReentrantReadWriteLock mergeLock;
    private ReentrantReadWriteLock.ReadLock mergeReadLock;
    private ReentrantReadWriteLock.WriteLock mergeWriteLock;
    private volatile boolean persisting;
    private volatile boolean inMerging;
    private ColumnarMemoryStorePersister memoryStorePersister;
    private String baseStorePath;
    private File dataSegmentFolder;
    private int maxRowsInMemory;
    private ParsedStreamingCubeInfo parsedStreamingCubeInfo;
    private String cubeName;
    private String segmentName;
    private boolean autoMergeEnabled;
    private List<DataSegmentFragment> fragments;
    protected int latestCheckpointFragment;
    private Map<TblColRef, Dictionary<String>> dictionaryMap;

    public ColumnarSegmentStore(String baseStorePath, CubeInstance cubeInstance, String segmentName) {
        fragmentMergeExecutor = new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("fragments-merge"));
        this.persistLock = new ReentrantReadWriteLock();
        this.persistReadLock = this.persistLock.readLock();
        this.persistWriteLock = this.persistLock.writeLock();
        this.mergeLock = new ReentrantReadWriteLock();
        this.mergeReadLock = this.mergeLock.readLock();
        this.mergeWriteLock = this.mergeLock.writeLock();
        this.persisting = false;
        this.inMerging = false;
        this.fragments = Lists.newCopyOnWriteArrayList();
        this.latestCheckpointFragment = 0;
        this.maxRowsInMemory = cubeInstance.getConfig().getStreamingIndexMaxRows();
        this.baseStorePath = baseStorePath;
        this.parsedStreamingCubeInfo = new ParsedStreamingCubeInfo(cubeInstance);
        this.cubeName = cubeInstance.getName();
        this.segmentName = segmentName;
        this.dataSegmentFolder = new File(baseStorePath + File.separator + this.cubeName + File.separator + segmentName);
        if (!this.dataSegmentFolder.exists()) {
            this.dataSegmentFolder.mkdirs();
        }
        this.activeMemoryStore = new SegmentMemoryStore(this.parsedStreamingCubeInfo, segmentName);
        this.memoryStorePersister = new ColumnarMemoryStorePersister(this.parsedStreamingCubeInfo, segmentName);
        this.autoMergeEnabled = cubeInstance.getConfig().isStreamingFragmentsAutoMergeEnabled();
        try {
            StreamingMetrics.getInstance().getMetricRegistry().register(MetricRegistry.name((String)"streaming.inMem.row.cnt", (String[])new String[]{cubeInstance.getName(), segmentName}), (Metric)new Gauge<Integer>(){

                public Integer getValue() {
                    return ColumnarSegmentStore.this.activeMemoryStore.getRowCount();
                }
            });
        }
        catch (Exception e) {
            logger.warn("metrics register failed", e);
        }
    }

    @Override
    public void init() {
        this.fragments.addAll(this.getFragmentsFromFileSystem());
    }

    @Override
    public int addEvent(StreamingMessage event) {
        if (this.activeMemoryStore == null) {
            throw new IllegalStateException("the segment has not opened:" + this.segmentName);
        }
        int rowsIndexed = this.activeMemoryStore.index(event);
        if (rowsIndexed >= this.maxRowsInMemory) {
            this.persist();
        }
        return rowsIndexed;
    }

    @Override
    public void addExternalDict(Map<TblColRef, Dictionary<String>> dictMap) {
        this.dictionaryMap = dictMap;
        this.activeMemoryStore.setDictionaryMap(dictMap);
    }

    @Override
    public File getStorePath() {
        return this.dataSegmentFolder;
    }

    @Override
    public Object checkpoint() {
        this.persist();
        this.latestCheckpointFragment = this.getLargestFragmentID();
        return String.valueOf(this.latestCheckpointFragment);
    }

    @Override
    public void persist() {
        DataSegmentFragment newFragment;
        if (this.activeMemoryStore.getRowCount() <= 0) {
            logger.info("no data in the memory store, skip persist.");
            return;
        }
        this.persistWriteLock.lock();
        try {
            this.persisting = true;
            newFragment = this.createNewFragment();
            this.persistingMemoryStore = this.activeMemoryStore;
            this.activeMemoryStore = new SegmentMemoryStore(this.parsedStreamingCubeInfo, this.segmentName);
            this.activeMemoryStore.setDictionaryMap(this.dictionaryMap);
        }
        finally {
            this.persistWriteLock.unlock();
        }
        this.memoryStorePersister.persist(this.persistingMemoryStore, newFragment);
        this.persistWriteLock.lock();
        try {
            this.persistingMemoryStore = null;
            this.fragments.add(newFragment);
            this.persisting = false;
        }
        finally {
            this.persistWriteLock.unlock();
        }
        this.checkRequireMerge();
    }

    private void checkRequireMerge() {
        if (!this.autoMergeEnabled || this.inMerging) {
            return;
        }
        KylinConfig config = this.parsedStreamingCubeInfo.cubeDesc.getConfig();
        int maxFragmentNum = config.getStreamingMaxFragmentsInSegment();
        if (this.fragments.size() <= maxFragmentNum) {
            return;
        }
        final List<DataSegmentFragment> fragmentsToMerge = this.chooseFragmentsToMerge(config, Lists.newArrayList(this.fragments));
        if (fragmentsToMerge.size() <= 1) {
            return;
        }
        logger.info("found some fragments need to merge:{}", (Object)fragmentsToMerge);
        this.inMerging = true;
        fragmentMergeExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ColumnarSegmentStore.this.doMergeFragments(fragmentsToMerge);
                }
                catch (Exception e) {
                    logger.error("error happens when merge fragments:" + fragmentsToMerge, e);
                }
            }
        });
    }

    protected void doMergeFragments(List<DataSegmentFragment> fragmentsToMerge) throws IOException {
        logger.info("start to merge fragments:{}", (Object)fragmentsToMerge);
        FragmentFilesMerger fragmentsMerger = new FragmentFilesMerger(this.parsedStreamingCubeInfo, this.dataSegmentFolder);
        FragmentsMergeResult mergeResult = fragmentsMerger.merge(fragmentsToMerge);
        logger.info("finish to merge fragments, try to commit the merge result");
        this.commitFragmentsMerge(mergeResult);
        fragmentsMerger.cleanMergeDirectory();
        this.inMerging = false;
    }

    protected List<DataSegmentFragment> chooseFragmentsToMerge(KylinConfig config, List<DataSegmentFragment> allFragments) {
        Collections.sort(allFragments);
        List<DataSegmentFragment> result = this.doChooseFragments(config, allFragments, true);
        return result;
    }

    protected List<DataSegmentFragment> doChooseFragments(KylinConfig config, List<DataSegmentFragment> allFragments, boolean ignoreMergedFragments) {
        ArrayList<DataSegmentFragment> result = Lists.newArrayList();
        int originFragmentsNum = allFragments.size();
        int minFragments = config.getStreamingMinFragmentsInSegment();
        long maxFragmentSize = (long)(config.getStreamingMaxFragmentSizeInMb() * 1024) * 1024L;
        long toMergeDataSize = 0L;
        for (int i = 0; i < originFragmentsNum; ++i) {
            DataSegmentFragment fragment = allFragments.get(i);
            if (originFragmentsNum - result.size() <= minFragments - 1) {
                return result;
            }
            if (fragment.getFragmentId().getEndId() > this.latestCheckpointFragment) {
                return result;
            }
            if (ignoreMergedFragments && fragment.isMergedFragment()) {
                if (result.size() > 1) {
                    return result;
                }
                if (result.size() != 1) continue;
                toMergeDataSize = 0L;
                result.clear();
                continue;
            }
            long fragmentDataSize = fragment.getDataFileSize();
            if (toMergeDataSize + fragmentDataSize <= maxFragmentSize) {
                toMergeDataSize += fragmentDataSize;
                result.add(fragment);
                continue;
            }
            if (result.size() > 1) {
                return result;
            }
            if (result.size() != 1) continue;
            toMergeDataSize = 0L;
            result.clear();
        }
        return result;
    }

    private void commitFragmentsMerge(FragmentsMergeResult mergeResult) throws IOException {
        this.mergeWriteLock.lock();
        try {
            mergeResult.getOrigFragments();
            this.removeFragments(mergeResult.getOrigFragments());
            DataSegmentFragment fragment = new DataSegmentFragment(this.baseStorePath, this.cubeName, this.segmentName, mergeResult.getMergedFragmentId());
            FileUtils.moveFileToDirectory(mergeResult.getMergedFragmentDataFile(), fragment.getFragmentFolder(), true);
            FileUtils.moveFileToDirectory(mergeResult.getMergedFragmentMetaFile(), fragment.getFragmentFolder(), true);
            this.fragments.add(fragment);
        }
        finally {
            this.mergeWriteLock.unlock();
        }
    }

    @Override
    public void purge() {
        try {
            FileUtils.deleteDirectory(this.dataSegmentFolder);
            logger.info("removed segment data, cube-{} segment-{}", (Object)this.cubeName, (Object)this.segmentName);
            ColumnarStoreCache.getInstance().removeFragmentsCache(this.fragments);
            this.fragments = Lists.newCopyOnWriteArrayList();
            logger.info("removed segment cache, cube-{} segment-{}", (Object)this.cubeName, (Object)this.segmentName);
        }
        catch (IOException e) {
            logger.error("error happens when purge segment", e);
        }
    }

    @Override
    public void restoreFromCheckpoint(Object checkpoint) {
        String checkpointFragmentIDString = (String)checkpoint;
        FragmentId checkpointFragmentID = FragmentId.parse(checkpointFragmentIDString);
        List<DataSegmentFragment> fragments = this.getFragmentsFromFileSystem();
        ArrayList<DataSegmentFragment> invalidFragments = Lists.newArrayList();
        for (DataSegmentFragment fragment : fragments) {
            if (fragment.getFragmentId().compareTo(checkpointFragmentID) <= 0) continue;
            fragment.purge();
            invalidFragments.add(fragment);
        }
        this.fragments.removeAll(invalidFragments);
    }

    @Override
    public String getSegmentName() {
        return this.segmentName;
    }

    @Override
    public StreamingCubeSegment.State getSegmentState() {
        File stateFile = new File(this.dataSegmentFolder, STATE_FILE);
        if (stateFile.exists()) {
            StreamingCubeSegment.State state = this.parseStateFile(stateFile);
            return state;
        }
        return StreamingCubeSegment.State.ACTIVE;
    }

    @Override
    public void setSegmentState(StreamingCubeSegment.State state) {
        File stateFile = new File(this.dataSegmentFolder, STATE_FILE);
        FileOutputStream outPut = null;
        try {
            if (!stateFile.exists()) {
                stateFile.createNewFile();
            }
            outPut = new FileOutputStream(stateFile);
            outPut.write(Bytes.toBytes(state.name()));
            outPut.flush();
        }
        catch (IOException e) {
            throw new IllegalStorageException(e);
        }
        finally {
            if (outPut != null) {
                try {
                    outPut.close();
                }
                catch (IOException e) {
                    logger.error("error when close", e);
                }
            }
        }
    }

    public DataSegmentFragment createNewFragment() {
        int largestFragID = this.getLargestFragmentID();
        DataSegmentFragment newFragment = new DataSegmentFragment(this.baseStorePath, this.cubeName, this.segmentName, new FragmentId(++largestFragID));
        return newFragment;
    }

    public List<DataSegmentFragment> getAllFragments() {
        return this.fragments;
    }

    private void removeFragments(List<DataSegmentFragment> fragmentsToRemove) {
        this.fragments.removeAll(Sets.newHashSet(fragmentsToRemove));
        for (DataSegmentFragment fragment : fragmentsToRemove) {
            ColumnarStoreCache.getInstance().removeFragmentCache(fragment);
            fragment.purge();
        }
    }

    private int getLargestFragmentID() {
        List<DataSegmentFragment> existingFragments = this.getFragmentsFromFileSystem();
        int largestFragId = 0;
        for (DataSegmentFragment existingFragment : existingFragments) {
            int id = existingFragment.getFragmentId().getEndId();
            if (id <= largestFragId) continue;
            largestFragId = id;
        }
        return largestFragId;
    }

    private List<DataSegmentFragment> getFragmentsFromFileSystem() {
        ArrayList<DataSegmentFragment> fragments = Lists.newArrayList();
        File dataSegmentFolder = this.getStorePath();
        File[] fragmentFolders = dataSegmentFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isDirectory()) {
                    return false;
                }
                if (file.getName().equalsIgnoreCase("_SUCCESS")) {
                    return false;
                }
                try {
                    FragmentId.parse(file.getName());
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
        });
        if (fragmentFolders != null) {
            for (File fragmentFolder : fragmentFolders) {
                fragments.add(new DataSegmentFragment(this.baseStorePath, this.cubeName, this.segmentName, FragmentId.parse(fragmentFolder.getName())));
            }
        }
        return fragments;
    }

    @Override
    public SegmentStoreStats getStoreStats() {
        SegmentStoreStats storeStats = new SegmentStoreStats();
        storeStats.setNumRowsInMem(this.activeMemoryStore.getRowCount());
        storeStats.setNumFragments(this.getFragmentsFromFileSystem().size());
        return storeStats;
    }

    public SegmentMemoryStore getActiveMemoryStore() {
        return this.activeMemoryStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(StreamingSearchContext searchContext, ResultCollector collector) throws IOException {
        SegmentMemoryStore searchMemoryStore;
        List<DataSegmentFragment> searchFragments;
        this.mergeReadLock.lock();
        collector.addCloseListener(new ResultCollector.CloseListener(){

            @Override
            public void onClose() {
                ColumnarSegmentStore.this.mergeReadLock.unlock();
            }
        });
        this.persistReadLock.lock();
        try {
            searchFragments = this.getAllFragments();
            searchMemoryStore = this.persisting ? this.persistingMemoryStore : this.activeMemoryStore;
        }
        finally {
            this.persistReadLock.unlock();
        }
        new ColumnarSegmentStoreFilesSearcher(this.segmentName, searchFragments).search(searchContext, collector);
        searchMemoryStore.search(searchContext, collector);
    }

    @Override
    public void close() throws IOException {
        logger.warn("closing the streaming cube segment, cube {}, segment {}.", (Object)this.cubeName, (Object)this.segmentName);
        StreamingMetrics.getInstance().getMetricRegistry().remove(MetricRegistry.name((String)"streaming.inMem.row.cnt", (String[])new String[]{this.cubeName, this.segmentName}));
    }

    private StreamingCubeSegment.State parseStateFile(File stateFile) {
        StreamingCubeSegment.State result = StreamingCubeSegment.State.ACTIVE;
        try {
            String stateName = Files.toString(stateFile, Charsets.UTF_8);
            result = StreamingCubeSegment.State.valueOf(stateName.trim());
        }
        catch (IOException e) {
            logger.error("error when parse state file", e);
        }
        return result;
    }
}

