/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataWriter;

public class GeneralColumnDataWriter
implements ColumnDataWriter {
    private DataOutputStream dataOutput;
    private int totalBytes;
    private int[] valueOffsets;
    private int valueNum;

    public GeneralColumnDataWriter(int numOfVals, DataOutputStream dataOutput) {
        this.dataOutput = dataOutput;
        this.valueOffsets = new int[numOfVals];
    }

    @Override
    public void write(byte[] value) throws IOException {
        this.write(value, 0, value.length);
    }

    public void write(byte[] value, int offset, int len) throws IOException {
        this.dataOutput.writeInt(len);
        this.dataOutput.write(value, offset, len);
        this.totalBytes += len + 4;
        this.valueOffsets[this.valueNum] = this.totalBytes;
        ++this.valueNum;
    }

    private void writeIndex() throws IOException {
        for (int i = 0; i < this.valueOffsets.length; ++i) {
            this.dataOutput.writeInt(this.valueOffsets[i]);
        }
        this.dataOutput.writeInt(this.valueOffsets.length);
    }

    @Override
    public void flush() throws IOException {
        this.writeIndex();
        this.dataOutput.flush();
    }
}

