/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncoding;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncodingFactory;

public class ParsedStreamingCubeInfo {
    public final CubeInstance cubeInstance;
    public final CubeDesc cubeDesc;
    public final CubeJoinedFlatTableEnrich intermediateTableDesc;
    public final MeasureDesc[] measureDescs;
    public final MeasureIngester<?>[] measureIngesters;
    public final String[] metricsAggrFuncs;
    public final int dimCount;
    public final int measureCount;
    public final TblColRef[] dimensions;
    public final TblColRef[] dimensionsUseDictEncoding;
    public final Cuboid basicCuboid;
    public List<CuboidInfo> additionalCuboidsToBuild;
    public CuboidToGridTableMapping basicCuboidMapping;
    private Map<String, TblColRef> dimensionsMap = Maps.newHashMap();

    public ParsedStreamingCubeInfo(CubeInstance cubeInstance) {
        this.cubeInstance = cubeInstance;
        this.cubeDesc = cubeInstance.getDescriptor();
        this.basicCuboid = Cuboid.getBaseCuboid(this.cubeDesc);
        this.intermediateTableDesc = new CubeJoinedFlatTableEnrich(new CubeJoinedFlatTableDesc(this.cubeDesc), this.cubeDesc);
        this.measureCount = this.cubeDesc.getMeasures().size();
        this.measureDescs = this.cubeDesc.getMeasures().toArray(new MeasureDesc[this.measureCount]);
        this.measureIngesters = MeasureIngester.create(this.cubeDesc.getMeasures());
        this.dimensions = this.basicCuboid.getColumns().toArray(new TblColRef[this.basicCuboid.getColumns().size()]);
        this.dimCount = this.dimensions.length;
        this.basicCuboidMapping = new CuboidToGridTableMapping(this.basicCuboid);
        boolean buildAdditionalCuboids = this.cubeDesc.getConfig().isStreamingBuildAdditionalCuboids();
        Set<Long> mandatoryCuboids = this.cubeDesc.getMandatoryCuboids();
        if (buildAdditionalCuboids) {
            this.additionalCuboidsToBuild = Lists.newArrayListWithCapacity(mandatoryCuboids.size());
            for (long cuboidID : mandatoryCuboids) {
                CuboidInfo cuboidInfo = new CuboidInfo(cuboidID);
                cuboidInfo.init(this.cubeDesc, this.intermediateTableDesc);
                this.additionalCuboidsToBuild.add(cuboidInfo);
            }
        }
        ArrayList<TblColRef> dimUseDictList = Lists.newArrayList();
        for (TblColRef column : this.dimensions) {
            this.dimensionsMap.put(column.getName(), column);
            if (!this.cubeDesc.getRowkey().isUseDictionary(column)) continue;
            dimUseDictList.add(column);
        }
        this.dimensionsUseDictEncoding = dimUseDictList.toArray(new TblColRef[dimUseDictList.size()]);
        ArrayList<String> metricsAggrFuncsList = Lists.newArrayListWithCapacity(this.measureCount);
        for (int i = 0; i < this.measureCount; ++i) {
            MeasureDesc measureDesc = this.measureDescs[i];
            metricsAggrFuncsList.add(measureDesc.getFunction().getExpression());
        }
        this.metricsAggrFuncs = metricsAggrFuncsList.toArray(new String[metricsAggrFuncsList.size()]);
    }

    public CubeInstance getCubeInstance() {
        return this.cubeInstance;
    }

    public CubeDesc getCubeDesc() {
        return this.cubeDesc;
    }

    public TblColRef[] getDimensions() {
        return this.dimensions;
    }

    public MeasureDesc[] getMeasures() {
        return this.measureDescs;
    }

    public MeasureIngester<?>[] getMeasureIngesters() {
        return this.measureIngesters;
    }

    public DataType[] getAllDataTypes() {
        return this.basicCuboidMapping.getDataTypes();
    }

    public DataTypeSerializer getMeasureTypeSerializer(int measureIdx) {
        DataType type = this.measureDescs[measureIdx].getFunction().getReturnDataType();
        return DataTypeSerializer.create(type);
    }

    public List<CuboidInfo> getAdditionalCuboidsToBuild() {
        return this.additionalCuboidsToBuild;
    }

    public CuboidToGridTableMapping getBasicCuboidToGridTableMapping() {
        return this.basicCuboidMapping;
    }

    public CuboidInfo getCuboidInfo(long cuboidId) {
        CuboidInfo cuboidInfo = new CuboidInfo(cuboidId);
        cuboidInfo.init(this.cubeDesc, this.intermediateTableDesc);
        return cuboidInfo;
    }

    public int getMetricIndexInAllMetrics(FunctionDesc metric) {
        return this.basicCuboidMapping.getIndexOf(metric) - this.dimensions.length;
    }

    public TblColRef getDimensionByName(String dimensionName) {
        return this.dimensionsMap.get(dimensionName);
    }

    public static DimensionEncoding[] getDimensionEncodings(CubeDesc cubeDesc, TblColRef[] dimensions, Map<TblColRef, Dictionary<String>> dimDictMap) {
        DimensionEncoding[] result = new DimensionEncoding[dimensions.length];
        for (int i = 0; i < dimensions.length; ++i) {
            TblColRef dimension = dimensions[i];
            RowKeyColDesc colDesc = cubeDesc.getRowkey().getColDesc(dimension);
            if (colDesc.isUsingDictionary()) {
                Dictionary<String> dict = dimDictMap.get(dimension);
                if (dict == null) {
                    throw new RuntimeException("No dictionary found for dict-encoding column " + dimension);
                }
                result[i] = new DictionaryDimEnc(dict);
                continue;
            }
            result[i] = DimensionEncodingFactory.create(colDesc.getEncodingName(), colDesc.getEncodingArgs(), colDesc.getEncodingVersion());
        }
        return result;
    }

    public static ColumnarMetricsEncoding[] getMetricsEncodings(MeasureDesc[] measures) {
        ColumnarMetricsEncoding[] result = new ColumnarMetricsEncoding[measures.length];
        for (int i = 0; i < measures.length; ++i) {
            result[i] = ColumnarMetricsEncodingFactory.create(measures[i].getFunction().getReturnDataType());
        }
        return result;
    }

    public void resetAggrs() {
        for (int i = 0; i < this.cubeDesc.getMeasures().size(); ++i) {
            this.measureIngesters[i].reset();
        }
    }

    public static class CuboidInfo {
        private long cuboidID;
        private int[] columnsIndex;
        private List<TblColRef> dimensions;

        public CuboidInfo(long cuboidID) {
            this.cuboidID = cuboidID;
        }

        public void init(CubeDesc cubeDesc, CubeJoinedFlatTableEnrich intermediateTableDesc) {
            this.dimensions = Lists.newArrayList();
            this.columnsIndex = new int[Long.bitCount(this.cuboidID)];
            int colIdx = 0;
            RowKeyColDesc[] allColumns = cubeDesc.getRowkey().getRowKeyColumns();
            for (int i = 0; i < allColumns.length; ++i) {
                long bitmask = 1L << allColumns[i].getBitIndex();
                if ((this.cuboidID & bitmask) == 0L) continue;
                TblColRef colRef = allColumns[i].getColRef();
                this.dimensions.add(colRef);
                this.columnsIndex[colIdx] = intermediateTableDesc.getColumnIndex(colRef);
                ++colIdx;
            }
        }

        public long getCuboidID() {
            return this.cuboidID;
        }

        public int[] getColumnsIndex() {
            if (this.columnsIndex == null) {
                throw new IllegalStateException("it is not initialized");
            }
            return this.columnsIndex;
        }

        public TblColRef[] getDimensions() {
            if (this.dimensions == null) {
                throw new IllegalStateException("it is not initialized");
            }
            return this.dimensions.toArray(new TblColRef[this.dimensions.size()]);
        }

        public int getDimCount() {
            return this.dimensions.size();
        }

        public int getIndexOf(TblColRef dimension) {
            return this.dimensions.indexOf(dimension);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CuboidInfo that = (CuboidInfo)o;
            return this.cuboidID == that.cuboidID;
        }

        public int hashCode() {
            return (int)(this.cuboidID ^ this.cuboidID >>> 32);
        }
    }
}

