/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.storage.hybrid.HybridManager;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.apache.kylin.tool.shaded.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendCubeToHybridCLI {
    public static final String ACL_INFO_FAMILY = "i";
    private static final String CUBE_POSTFIX = "_old";
    private static final String HYBRID_POSTFIX = "_hybrid";
    private static final Logger logger = LoggerFactory.getLogger(ExtendCubeToHybridCLI.class);
    private static final String ACL_INFO_FAMILY_PARENT_COLUMN = "p";
    private KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
    private CubeManager cubeManager;
    private CubeDescManager cubeDescManager;
    private DataModelManager metadataManager;
    private ResourceStore store = ResourceStore.getStore(this.kylinConfig);

    public ExtendCubeToHybridCLI() {
        this.cubeManager = CubeManager.getInstance(this.kylinConfig);
        this.cubeDescManager = CubeDescManager.getInstance(this.kylinConfig);
        this.metadataManager = DataModelManager.getInstance(this.kylinConfig);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2 && args.length != 3) {
            System.out.println("Usage: ExtendCubeToHybridCLI project cube [partition_date]");
            return;
        }
        ExtendCubeToHybridCLI tool = new ExtendCubeToHybridCLI();
        String projectName = args[0];
        String cubeName = args[1];
        String partitionDate = args.length == 3 ? args[2] : null;
        try {
            tool.createFromCube(projectName, cubeName, partitionDate);
            tool.verify();
            logger.info("Job Finished.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Job Aborted.", (Object)e.getMessage());
        }
    }

    private boolean validateCubeInstance(CubeInstance cubeInstance) {
        if (cubeInstance == null) {
            logger.error("This cube does not exist.");
            return false;
        }
        if (cubeInstance.getSegments().isEmpty()) {
            logger.error("No segments in this cube, no need to extend.");
            return false;
        }
        return true;
    }

    public void createFromCube(String projectName, String cubeName, String partitionDateStr) throws Exception {
        logger.info("Create hybrid for cube[" + cubeName + "], project[" + projectName + "], partition_date[" + partitionDateStr + "].");
        CubeInstance cubeInstance = this.cubeManager.getCube(cubeName);
        if (!this.validateCubeInstance(cubeInstance)) {
            return;
        }
        CubeDesc cubeDesc = this.cubeDescManager.getCubeDesc(cubeInstance.getDescName());
        DataModelDesc dataModelDesc = this.metadataManager.getDataModelDesc(cubeDesc.getModelName());
        if (StringUtils.isEmpty(dataModelDesc.getPartitionDesc().getPartitionDateColumn())) {
            logger.error("No incremental cube, no need to extend.");
            return;
        }
        String owner = cubeInstance.getOwner();
        long partitionDate = partitionDateStr != null ? DateFormat.stringToMillis(partitionDateStr) : 0L;
        String newCubeDescName = this.renameCube(cubeDesc.getName());
        String newCubeInstanceName = this.renameCube(cubeInstance.getName());
        while (this.cubeDescManager.getCubeDesc(newCubeDescName) != null) {
            newCubeDescName = this.renameCube(newCubeDescName);
        }
        while (this.cubeManager.getCube(newCubeInstanceName) != null) {
            newCubeInstanceName = this.renameCube(newCubeInstanceName);
        }
        CubeInstance newCubeInstance = CubeInstance.getCopyOf(cubeInstance);
        newCubeInstance.setName(newCubeInstanceName);
        newCubeInstance.setDescName(newCubeDescName);
        newCubeInstance.updateRandomUuid();
        Iterator segmentIterator = newCubeInstance.getSegments().iterator();
        CubeSegment currentSeg = null;
        while (segmentIterator.hasNext()) {
            currentSeg = (CubeSegment)segmentIterator.next();
            if (partitionDateStr == null || (Long)currentSeg.getTSRange().start.v < partitionDate && (Long)currentSeg.getTSRange().end.v <= partitionDate) continue;
            segmentIterator.remove();
            logger.info("CubeSegment[" + currentSeg + "] was removed.");
        }
        if (currentSeg != null && partitionDateStr != null && partitionDate != (Long)currentSeg.getTSRange().end.v) {
            logger.error("PartitionDate must be end date of one segment.");
            return;
        }
        if (currentSeg != null && partitionDateStr == null) {
            partitionDate = (Long)currentSeg.getTSRange().end.v;
        }
        this.cubeManager.createCube(newCubeInstance, projectName, owner);
        logger.info("CubeInstance was saved at: " + newCubeInstance.getResourcePath());
        CubeDesc newCubeDesc = CubeDesc.getCopyOf(cubeDesc);
        newCubeDesc.setName(newCubeDescName);
        newCubeDesc.updateRandomUuid();
        newCubeDesc.init(this.kylinConfig);
        newCubeDesc.setPartitionDateEnd(partitionDate);
        newCubeDesc.calculateSignature();
        this.cubeDescManager.createCubeDesc(newCubeDesc);
        logger.info("CubeDesc was saved at: " + newCubeDesc.getResourcePath());
        cubeDesc.setPartitionDateStart(partitionDate);
        cubeDesc.setEngineType(2);
        cubeDesc.setStorageType(2);
        cubeDesc.calculateSignature();
        this.cubeDescManager.updateCubeDesc(cubeDesc);
        logger.info("CubeDesc was saved at: " + cubeDesc.getResourcePath());
        cubeInstance.setSegments(new Segments());
        cubeInstance.setStatus(RealizationStatusEnum.DISABLED);
        this.store.checkAndPutResource(cubeInstance.getResourcePath(), cubeInstance, CubeManager.CUBE_SERIALIZER);
        logger.info("CubeInstance was saved at: " + cubeInstance.getResourcePath());
        ArrayList<RealizationEntry> realizationEntries = Lists.newArrayListWithCapacity(2);
        realizationEntries.add(RealizationEntry.create(RealizationType.CUBE, cubeInstance.getName()));
        realizationEntries.add(RealizationEntry.create(RealizationType.CUBE, newCubeInstance.getName()));
        HybridInstance hybridInstance = HybridInstance.create(this.kylinConfig, this.renameHybrid(cubeInstance.getName()), realizationEntries);
        this.store.checkAndPutResource(hybridInstance.getResourcePath(), hybridInstance, HybridManager.HYBRID_SERIALIZER);
        ProjectManager.getInstance(this.kylinConfig).moveRealizationToProject(RealizationType.HYBRID, hybridInstance.getName(), projectName, owner);
        logger.info("HybridInstance was saved at: " + hybridInstance.getResourcePath());
        this.copyAcl(cubeInstance.getId(), newCubeInstance.getId(), projectName);
        logger.info("Acl copied from [" + cubeName + "] to [" + newCubeInstanceName + "].");
    }

    private void verify() {
        this.kylinConfig.clearManagers();
        CubeDescManager.getInstance(this.kylinConfig);
        CubeManager.getInstance(this.kylinConfig);
        ProjectManager.getInstance(this.kylinConfig);
        HybridManager.getInstance(this.kylinConfig);
    }

    private String renameCube(String origName) {
        return origName + CUBE_POSTFIX;
    }

    private String renameHybrid(String origName) {
        return origName + HYBRID_POSTFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAcl(String origCubeId, String newCubeId, String projectName) throws Exception {
        String projectResPath = ProjectInstance.concatResourcePath(projectName);
        JsonSerializer<ProjectInstance> projectSerializer = new JsonSerializer<ProjectInstance>(ProjectInstance.class);
        ProjectInstance project = this.store.getResource(projectResPath, projectSerializer);
        String projUUID = project.getUuid();
        Table aclHtable = null;
        try {
            aclHtable = HBaseConnection.get(this.kylinConfig.getStorageUrl()).getTable(TableName.valueOf((String)(this.kylinConfig.getMetadataUrlPrefix() + "_acl")));
            Result result = aclHtable.get(new Get(Bytes.toBytes(origCubeId)));
            if (result.listCells() != null) {
                for (Cell cell : result.listCells()) {
                    byte[] family = CellUtil.cloneFamily((Cell)cell);
                    byte[] column = CellUtil.cloneQualifier((Cell)cell);
                    byte[] value = CellUtil.cloneValue((Cell)cell);
                    if (Bytes.toString(family).equals(ACL_INFO_FAMILY) && Bytes.toString(column).equals(ACL_INFO_FAMILY_PARENT_COLUMN)) {
                        String valueString = "{\"id\":\"" + projUUID + "\",\"type\":\"org.apache.kylin.metadata.project.ProjectInstance\"}";
                        value = Bytes.toBytes(valueString);
                    }
                    Put put = new Put(Bytes.toBytes(newCubeId));
                    put.addColumn(family, column, value);
                    aclHtable.put(put);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(aclHtable);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)aclHtable);
    }
}

