/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.sampling;

import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRegion;
import com.yahoo.memory.NativeMemory;
import com.yahoo.sketches.sampling.PreambleUtil;
import com.yahoo.sketches.sampling.ReservoirSize;

final class VersionConverter {
    VersionConverter() {
    }

    static Memory convertSketch1to2(Memory srcMem) {
        return VersionConverter.perform1to2Changes(srcMem);
    }

    static Memory convertUnion1to2(Memory srcMem) {
        boolean isEmpty;
        Memory converted = VersionConverter.perform1to2Changes(srcMem);
        Object memObj = converted.array();
        long memAddr = converted.getCumulativeOffset(0L);
        int preLongs = PreambleUtil.extractPreLongs(memObj, memAddr);
        int flags = PreambleUtil.extractFlags(memObj, memAddr);
        boolean bl = isEmpty = (flags & 4) > 0;
        if (!isEmpty) {
            int memCap = (int)converted.getCapacity();
            int preLongBytes = preLongs << 3;
            MemoryRegion sketchMem = new MemoryRegion(converted, preLongBytes, memCap - preLongBytes);
            VersionConverter.convertSketch1to2(sketchMem);
        }
        return converted;
    }

    private static Memory perform1to2Changes(Memory srcMem) {
        int memCap = (int)srcMem.getCapacity();
        Memory converted = srcMem;
        if (srcMem.isReadOnly()) {
            byte[] data = new byte[memCap];
            srcMem.getByteArray(0L, data, 0, memCap);
            converted = new NativeMemory(data);
        }
        Object memObj = converted.array();
        long memAddr = converted.getCumulativeOffset(0L);
        short encodedK = PreambleUtil.extractEncodedReservoirSize(memObj, memAddr);
        int k = ReservoirSize.decodeValue(encodedK);
        PreambleUtil.insertReservoirSize(memObj, memAddr, k);
        PreambleUtil.insertSerVer(memObj, memAddr, 2);
        return converted;
    }
}

