/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;

public class StringEntity
extends RootPersistentEntity
implements Comparable<StringEntity> {
    public static final Serializer<StringEntity> serializer = new Serializer<StringEntity>(){

        @Override
        public void serialize(StringEntity obj, DataOutputStream out) throws IOException {
            out.writeUTF(obj.str);
        }

        @Override
        public StringEntity deserialize(DataInputStream in) throws IOException {
            String str = in.readUTF();
            return new StringEntity(str);
        }
    };
    String str;

    public StringEntity(String str) {
        this.str = str;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.str == null ? 0 : this.str.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StringEntity)) {
            return false;
        }
        return StringUtils.equals((String)this.str, (String)((StringEntity)obj).str);
    }

    public String toString() {
        return this.str;
    }

    @Override
    public int compareTo(StringEntity o) {
        if (this.str == null) {
            return o.str == null ? 0 : -1;
        }
        if (o.str == null) {
            return 1;
        }
        return this.str.compareTo(o.str);
    }
}

