/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.metadata.model.TableDesc;

public abstract class AbstractLookupRowEncoder<R> {
    protected ByteBuffer keyByteBuffer = ByteBuffer.allocate(0x100000);
    protected int columnsNum;
    protected int[] keyIndexes;
    protected int[] valueIndexes;

    public AbstractLookupRowEncoder(TableDesc tableDesc, String[] keyColumns) {
        this.columnsNum = tableDesc.getColumns().length;
        this.keyIndexes = new int[keyColumns.length];
        this.valueIndexes = new int[this.columnsNum - keyColumns.length];
        int keyIdx = 0;
        int valIdx = 0;
        for (int i = 0; i < this.columnsNum; ++i) {
            boolean isKeyColumn = false;
            for (String keyColumn : keyColumns) {
                if (!keyColumn.equals(tableDesc.getColumns()[i].getName())) continue;
                isKeyColumn = true;
                break;
            }
            if (isKeyColumn) {
                this.keyIndexes[keyIdx] = i;
                ++keyIdx;
                continue;
            }
            this.valueIndexes[valIdx] = i;
            ++valIdx;
        }
    }

    public abstract R encode(String[] var1);

    public abstract String[] decode(R var1);

    public String[] getKeyData(String[] row) {
        return this.extractColValues(row, this.keyIndexes);
    }

    public String[] getValueData(String[] row) {
        return this.extractColValues(row, this.valueIndexes);
    }

    public byte[] encodeStringsWithLenPfx(String[] keys, boolean allowNull) {
        this.keyByteBuffer.clear();
        for (String key : keys) {
            if (key == null && !allowNull) {
                throw new IllegalArgumentException("key cannot be null:" + Arrays.toString(keys));
            }
            byte[] byteKey = this.toBytes(key);
            this.keyByteBuffer.putShort((short)byteKey.length);
            this.keyByteBuffer.put(byteKey);
        }
        byte[] result = new byte[this.keyByteBuffer.position()];
        System.arraycopy(this.keyByteBuffer.array(), 0, result, 0, this.keyByteBuffer.position());
        return result;
    }

    protected void decodeFromLenPfxBytes(byte[] rowKey, int[] valueIdx, String[] result) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(rowKey);
        for (int i = 0; i < valueIdx.length; ++i) {
            short keyLen = byteBuffer.getShort();
            byte[] keyBytes = new byte[keyLen];
            byteBuffer.get(keyBytes);
            result[valueIdx[i]] = this.fromBytes(keyBytes);
        }
    }

    protected String[] extractColValues(String[] row, int[] indexes) {
        String[] result = new String[indexes.length];
        int i = 0;
        for (int idx : indexes) {
            result[i++] = row[idx];
        }
        return result;
    }

    protected byte[] toBytes(String str) {
        if (str == null) {
            return new byte[]{-1};
        }
        return Bytes.toBytes(str);
    }

    protected String fromBytes(byte[] bytes) {
        if (DimensionEncoding.isNull(bytes, 0, bytes.length)) {
            return null;
        }
        return Bytes.toString(bytes);
    }
}

