/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.flink;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.flink.FlinkCubingByLayer;
import org.apache.kylin.engine.flink.FlinkOnYarnConfigMapping;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.JobRelatedMetaUtil;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.exception.PersistentException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.metadata.model.Segments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkExecutable
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(FlinkExecutable.class);
    private static final String CLASS_NAME = "className";
    private static final String JARS = "jars";
    private static final String JOB_ID = "jobId";
    private static final String COUNTER_SAVE_AS = "CounterSaveAs";
    private static final String CONFIG_NAME = "configName";

    public void setClassName(String className) {
        this.setParam(CLASS_NAME, className);
    }

    public void setJobId(String jobId) {
        this.setParam(JOB_ID, jobId);
    }

    public void setJars(String jars) {
        this.setParam(JARS, jars);
    }

    public void setCounterSaveAs(String value) {
        this.setParam(COUNTER_SAVE_AS, value);
    }

    public void setCounterSaveAs(String value, String counterOutputPath) {
        this.setParam(COUNTER_SAVE_AS, value);
        this.setParam("counterOutput", counterOutputPath);
    }

    public String getCounterSaveAs() {
        return this.getParam(COUNTER_SAVE_AS);
    }

    public void setFlinkConfigName(String configName) {
        this.setParam(CONFIG_NAME, configName);
    }

    public String getFlinkConfigName() {
        return this.getParam(CONFIG_NAME);
    }

    private String formatArgs() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.getParams().entrySet()) {
            StringBuilder tmp = new StringBuilder();
            tmp.append("-").append(entry.getKey()).append(" ").append(entry.getValue()).append(" ");
            if (entry.getKey().equals(CLASS_NAME)) {
                stringBuilder.insert(0, tmp);
                continue;
            }
            if (entry.getKey().equals(JARS) || entry.getKey().equals(JOB_ID) || entry.getKey().equals(COUNTER_SAVE_AS) || entry.getKey().equals(CONFIG_NAME)) continue;
            stringBuilder.append((CharSequence)tmp);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1).toString();
        }
        return "";
    }

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException, PersistentException {
        ExecutableManager manager = this.getManager();
        Map<String, String> extra = manager.getOutput(this.getId()).getExtra();
        String flinkJobId = extra.get("flink_job_id");
        if (!StringUtils.isEmpty((String)flinkJobId)) {
            return this.onResumed(flinkJobId, manager);
        }
        String cubeName = this.getParam(FlinkCubingByLayer.OPTION_CUBE_NAME.getOpt());
        CubeInstance cube = CubeManager.getInstance(context.getConfig()).getCube(cubeName);
        KylinConfig config = cube.getConfig();
        this.setAlgorithmLayer();
        if (KylinConfig.getFlinkHome() == null) {
            throw new NullPointerException();
        }
        if (config.getKylinJobJarPath() == null) {
            throw new NullPointerException();
        }
        String jars = this.getParam(JARS);
        String hadoopConf = System.getProperty("kylin.hadoop.conf.dir");
        if (StringUtils.isEmpty((String)hadoopConf)) {
            throw new RuntimeException("kylin_hadoop_conf_dir is empty, check if there's error in the output of 'kylin.sh start'");
        }
        logger.info("Using " + hadoopConf + " as HADOOP_CONF_DIR");
        String hadoopClasspathEnv = new File(hadoopConf).getParentFile().getAbsolutePath();
        String jobJar = config.getKylinJobJarPath();
        String segmentID = this.getParam(FlinkCubingByLayer.OPTION_SEGMENT_ID.getOpt());
        CubeSegment segment = cube.getSegmentById(segmentID);
        Segments<CubeSegment> mergingSeg = cube.getMergingSegments(segment);
        this.dumpMetadata(segment, mergingSeg);
        StringBuilder sb = new StringBuilder();
        if (Shell.osType == Shell.OSType.OS_TYPE_WIN) {
            sb.append("set HADOOP_CONF_DIR=%s && set HADOOP_CLASSPATH=%s && %s/bin/flink run -m yarn-cluster ");
        } else {
            sb.append("export HADOOP_CONF_DIR=%s && export HADOOP_CLASSPATH=%s && %s/bin/flink run -m yarn-cluster ");
        }
        Map<String, String> flinkConfs = config.getFlinkConfigOverride();
        String flinkConfigName = this.getFlinkConfigName();
        if (flinkConfigName != null) {
            Map<String, String> flinkSpecificConfs = config.getFlinkConfigOverrideWithSpecificName(flinkConfigName);
            flinkSpecificConfs.putAll(flinkConfs);
        }
        int parallelism = 1;
        for (Map.Entry<String, String> entry : flinkConfs.entrySet()) {
            if (!(FlinkOnYarnConfigMapping.flinkOnYarnConfigMap.containsKey(entry.getKey()) || entry.getKey().startsWith("program") || entry.getKey().startsWith("job"))) {
                logger.error("Unsupported Flink configuration pair : key[%s], value[%s]", (Object)entry.getKey(), (Object)entry.getValue());
                throw new IllegalArgumentException("Unsupported Flink configuration pair : key[" + entry.getKey() + "], value[" + entry.getValue() + "]");
            }
            if (entry.getKey().equals("job.parallelism")) {
                parallelism = Integer.parseInt(entry.getValue());
                continue;
            }
            if (entry.getKey().startsWith("program.")) {
                this.getParams().put(entry.getKey().replaceAll("program.", ""), entry.getValue());
                continue;
            }
            String configOptionKey = FlinkOnYarnConfigMapping.flinkOnYarnConfigMap.get(entry.getKey());
            if (configOptionKey.startsWith("-y") && !entry.getValue().isEmpty()) {
                sb.append(" ").append(configOptionKey).append(" ").append(entry.getValue());
                continue;
            }
            if (configOptionKey.startsWith("-y")) continue;
            sb.append(" ").append(configOptionKey).append("=").append(entry.getValue());
        }
        sb.append(" -ynm ").append(this.getName().replaceAll(" ", "-")).append(" ");
        if (StringUtils.isNotBlank((String)jars)) {
            String[] splitJars = jars.split(",\\s*");
            HashSet<String> setJars = new HashSet<String>();
            setJars.addAll(Arrays.asList(splitJars));
            for (String jar : setJars) {
                sb.append(String.format(Locale.ROOT, " -C file://%s", jar));
            }
        }
        sb.append(" -c org.apache.kylin.common.util.FlinkEntry -p %s %s %s ");
        String cmd = String.format(Locale.ROOT, sb.toString(), hadoopConf, hadoopClasspathEnv, KylinConfig.getFlinkHome(), parallelism, jobJar, this.formatArgs());
        logger.info("cmd: " + cmd);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        CliCommandExecutor exec = new CliCommandExecutor();
        PatternedLogger patternedLogger = new PatternedLogger(logger, 5, (infoKey, info) -> {
            if ("flink_job_id".equals(infoKey) || "yarn_application_id".equals(infoKey) || "yarn_application_tracking_url".equals(infoKey)) {
                this.getManager().addJobInfo(this.getId(), info);
            }
        });
        try {
            Future<Pair> future = executorService.submit(() -> {
                Pair<Integer, String> result;
                try {
                    result = exec.execute(cmd, patternedLogger);
                }
                catch (Exception e) {
                    logger.error("error run Flink job:", e);
                    result = new Pair<Integer, String>(-1, e.getMessage());
                }
                return result;
            });
            Pair result = null;
            while (!this.isDiscarded() && !this.isPaused()) {
                if (future.isDone()) {
                    result = future.get();
                    break;
                }
                Thread.sleep(5000L);
            }
            if (!future.isDone()) {
                executorService.shutdownNow();
                extra = manager.getOutput(this.getId()).getExtra();
                if (extra != null && extra.get("flink_job_id") != null) {
                    this.killAppRetry(extra.get("flink_job_id"));
                }
                if (this.isDiscarded()) {
                    return new ExecuteResult(ExecuteResult.State.DISCARDED, "Discarded");
                }
                if (this.isPaused()) {
                    return new ExecuteResult(ExecuteResult.State.STOPPED, "Stopped");
                }
                throw new IllegalStateException();
            }
            if (result == null) {
                result = future.get();
            }
            if (result != null && (Integer)result.getFirst() == 0) {
                Map<String, String> joblogInfo = patternedLogger.getInfo();
                String counterOutput = this.getParam("counterOutput");
                if (counterOutput != null) {
                    if (HadoopUtil.getWorkingFileSystem().exists(new Path(counterOutput))) {
                        Map<String, String> counterMap = HadoopUtil.readFromSequenceFile(counterOutput);
                        joblogInfo.putAll(counterMap);
                    } else {
                        logger.warn("Flink counter output path not exists: " + counterOutput);
                    }
                }
                this.readCounters(joblogInfo);
                this.getManager().addJobInfo(this.getId(), joblogInfo);
                return new ExecuteResult(ExecuteResult.State.SUCCEED, patternedLogger.getBufferedLog());
            }
            extra = manager.getOutput(this.getId()).getExtra();
            extra.put("flink_job_id", "");
            this.getManager().addJobInfo(this.getId(), extra);
            return new ExecuteResult(ExecuteResult.State.ERROR, result != null ? (String)result.getSecond() : "");
        }
        catch (Exception e) {
            logger.error("error run Flink job:", e);
            return ExecuteResult.createError(e);
        }
    }

    private ExecuteResult onResumed(String appId, ExecutableManager mgr) throws ExecuteException {
        HashMap<String, String> info = new HashMap<String, String>();
        try {
            logger.info("flink_job_id:" + appId + " resumed");
            info.put("flink_job_id", appId);
            while (!this.isPaused() && !this.isDiscarded()) {
                String status = this.getAppState(appId);
                if (status.equals("FAILED") || status.equals("KILLED")) {
                    mgr.updateJobOutput(this.getId(), ExecutableState.ERROR, null, appId + " has failed");
                    return new ExecuteResult(ExecuteResult.State.FAILED, appId + " has failed");
                }
                if (status.equals("SUCCEEDED")) {
                    mgr.addJobInfo(this.getId(), info);
                    return new ExecuteResult(ExecuteResult.State.SUCCEED, appId + " has finished");
                }
                Thread.sleep(5000L);
            }
            this.killAppRetry(appId);
            if (this.isDiscarded()) {
                return new ExecuteResult(ExecuteResult.State.DISCARDED, appId + " is discarded");
            }
            return new ExecuteResult(ExecuteResult.State.STOPPED, appId + " is stopped");
        }
        catch (Exception e) {
            logger.error("error run spark job:", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }

    private String getAppState(String appId) throws IOException {
        CliCommandExecutor executor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
        PatternedLogger patternedLogger = new PatternedLogger(logger);
        String stateCmd = String.format(Locale.ROOT, "yarn application -status %s", appId);
        executor.execute(stateCmd, patternedLogger);
        Map<String, String> info = patternedLogger.getInfo();
        return info.get("yarn_application_state");
    }

    private void setAlgorithmLayer() {
        ExecutableManager execMgr = ExecutableManager.getInstance(KylinConfig.getInstanceFromEnv());
        CubingJob cubingJob = (CubingJob)execMgr.getJob(this.getParam(JOB_ID));
        cubingJob.setAlgorithm(CubingJob.AlgorithmEnum.LAYER);
    }

    private void dumpMetadata(CubeSegment segment, List<CubeSegment> mergingSeg) throws ExecuteException {
        try {
            if (mergingSeg == null || mergingSeg.size() == 0) {
                this.attachSegmentMetadataWithDict(segment);
            } else {
                ArrayList<CubeSegment> allRelatedSegs = new ArrayList<CubeSegment>();
                allRelatedSegs.add(segment);
                allRelatedSegs.addAll(mergingSeg);
                this.attachSegmentsMetadataWithDict(allRelatedSegs);
            }
        }
        catch (IOException e) {
            throw new ExecuteException("meta dump failed");
        }
    }

    private void attachSegmentMetadataWithDict(CubeSegment segment) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.addAll(JobRelatedMetaUtil.collectCubeMetadata(segment.getCubeInstance()));
        dumpList.addAll(segment.getDictionaryPaths());
        ResourceStore rs = ResourceStore.getStore(segment.getConfig());
        if (rs.exists(segment.getStatisticsResourcePath())) {
            dumpList.add(segment.getStatisticsResourcePath());
        }
        JobRelatedMetaUtil.dumpAndUploadKylinPropsAndMetadata(dumpList, (KylinConfigExt)segment.getConfig(), this.getParam(FlinkCubingByLayer.OPTION_META_URL.getOpt()));
    }

    private void attachSegmentsMetadataWithDict(List<CubeSegment> segments) throws IOException {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.addAll(JobRelatedMetaUtil.collectCubeMetadata(segments.get(0).getCubeInstance()));
        ResourceStore rs = ResourceStore.getStore(segments.get(0).getConfig());
        for (CubeSegment segment : segments) {
            dumpList.addAll(segment.getDictionaryPaths());
            if (!rs.exists(segment.getStatisticsResourcePath())) continue;
            dumpList.add(segment.getStatisticsResourcePath());
        }
        JobRelatedMetaUtil.dumpAndUploadKylinPropsAndMetadata(dumpList, (KylinConfigExt)segments.get(0).getConfig(), this.getParam(FlinkCubingByLayer.OPTION_META_URL.getOpt()));
    }

    private int killAppRetry(String appId) throws IOException, InterruptedException {
        String state = this.getAppState(appId);
        if ("SUCCEEDED".equals(state) || "FAILED".equals(state) || "KILLED".equals(state)) {
            logger.warn(appId + "is final state, no need to kill");
            return 0;
        }
        this.killApp(appId);
        state = this.getAppState(appId);
        for (int retry = 0; state == null || !state.equals("KILLED") && retry < 5; ++retry) {
            this.killApp(appId);
            Thread.sleep(1000L);
            state = this.getAppState(appId);
        }
        if ("KILLED".equals(state)) {
            logger.info(appId + " killed successfully");
            return 0;
        }
        logger.info(appId + " killed failed");
        return 1;
    }

    private void killApp(String appId) throws IOException, InterruptedException {
        CliCommandExecutor executor = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
        String killCmd = String.format(Locale.ROOT, "yarn application -kill %s", appId);
        executor.execute(killCmd);
    }

    private void readCounters(Map<String, String> info) {
        String counterSaveAs = this.getCounterSaveAs();
        if (counterSaveAs != null) {
            String[] saveAsNames = counterSaveAs.split(",");
            this.saveCounterAs(info.get("source_records_count"), saveAsNames, 0, info);
            this.saveCounterAs(info.get("source_records_size"), saveAsNames, 1, info);
            this.saveCounterAs(info.get("hdfs_bytes_written"), saveAsNames, 2, info);
        }
    }

    private void saveCounterAs(String counter, String[] saveAsNames, int i, Map<String, String> info) {
        if (saveAsNames.length > i && !StringUtils.isBlank((String)saveAsNames[i])) {
            info.put(saveAsNames[i].trim(), counter);
        }
    }
}

