/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.KeyValueTextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.LazyOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.steps.BuildGlobalHiveDictTotalBuildMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildGlobalHiveDictTotalBuildJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(BuildGlobalHiveDictTotalBuildJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        Options options = new Options();
        String[] dicColsArr = null;
        try {
            options.addOption(OPTION_JOB_NAME);
            options.addOption(OPTION_INPUT_PATH);
            options.addOption(OPTION_OUTPUT_PATH);
            options.addOption(OPTION_CUBE_NAME);
            options.addOption(OPTION_SEGMENT_ID);
            options.addOption(OPTION_GLOBAL_DIC_MAX_DISTINCT_COUNT);
            options.addOption(OPTION_GLOBAL_DIC_PART_REDUCE_STATS);
            this.parseOptions(options, args);
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            dicColsArr = config.getMrHiveDictColumnsExcludeRefColumns();
            String cubeName = this.getOptionValue(OPTION_CUBE_NAME);
            String segmentID = this.getOptionValue(OPTION_SEGMENT_ID);
            this.job = Job.getInstance((Configuration)this.getConf(), (String)this.getOptionValue(OPTION_JOB_NAME));
            logger.info("Starting: " + this.job.getJobName());
            CubeManager cubeMgr = CubeManager.getInstance(config);
            CubeInstance cube = cubeMgr.getCube(cubeName);
            CubeSegment segment = cube.getSegmentById(segmentID);
            this.job.getConfiguration().set("cube.name", cubeName);
            this.job.getConfiguration().set("cube.segment.id", segmentID);
            this.job.getConfiguration().set("partition.statistics.path", this.getOptionValue(OPTION_GLOBAL_DIC_PART_REDUCE_STATS));
            this.job.getConfiguration().set("last.max.dic.value.path", this.getOptionValue(OPTION_GLOBAL_DIC_MAX_DISTINCT_COUNT));
            this.job.getConfiguration().setBoolean("mapreduce.output.fileoutputformat.compress", false);
            this.job.setJarByClass(BuildGlobalHiveDictTotalBuildJob.class);
            this.setJobClasspath(this.job, cube.getConfig());
            this.job.setMapperClass(BuildGlobalHiveDictTotalBuildMapper.class);
            this.setInput(this.job, this.getOptionValue(OPTION_INPUT_PATH));
            this.setOutput(this.job, dicColsArr, this.getOptionValue(OPTION_OUTPUT_PATH));
            this.job.setNumReduceTasks(0);
            this.job.setInputFormatClass(KeyValueTextInputFormat.class);
            LazyOutputFormat.setOutputFormatClass((Job)this.job, TextOutputFormat.class);
            Path baseOutputPath = new Path(this.getOptionValue(OPTION_OUTPUT_PATH));
            this.deletePath(this.job.getConfiguration(), baseOutputPath);
            this.attachSegmentMetadataWithDict(segment, this.job.getConfiguration());
            int n = this.waitForCompletion(this.job);
            return n;
        }
        finally {
            if (this.job != null) {
                this.cleanupTempConfFile(this.job.getConfiguration());
            }
        }
    }

    private void setOutput(Job job, String[] dicColsArr, String outputBase) {
        for (int i = 0; i < dicColsArr.length; ++i) {
            MultipleOutputs.addNamedOutput((Job)job, (String)(i + ""), TextOutputFormat.class, Text.class, LongWritable.class);
        }
        Path outputPath = new Path(outputBase);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
    }

    private void setInput(Job job, String input) throws IOException {
        Path path = new Path(input);
        FileSystem fs = path.getFileSystem(job.getConfiguration());
        if (!fs.exists(path)) {
            fs.mkdirs(path);
        }
        FileInputFormat.setInputPaths((Job)job, (String)this.getOptionValue(OPTION_INPUT_PATH));
    }
}

