/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.common.RowKeySplitter;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.RowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyEncoderProvider;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class SegmentReEncoder
implements Serializable {
    private volatile transient boolean initialized = false;
    private CubeSegment mergingSeg;
    private CubeSegment mergedSeg;
    private byte[] newKeyBodyBuf;
    private ByteArray newKeyBuf;
    private RowKeySplitter rowKeySplitter;
    private RowKeyEncoderProvider rowKeyEncoderProvider;
    private List<Pair<Integer, MeasureIngester>> dictMeasures;
    private Map<TblColRef, Dictionary<String>> oldDicts;
    private Map<TblColRef, Dictionary<String>> newDicts;
    private List<MeasureDesc> measureDescs;
    private BufferedMeasureCodec codec;
    private CubeDesc cubeDesc;
    private KylinConfig kylinConfig;
    private Text textValue = new Text();

    public SegmentReEncoder(CubeDesc cubeDesc, CubeSegment mergingSeg, CubeSegment mergedSeg, KylinConfig kylinConfig) {
        this.cubeDesc = cubeDesc;
        this.mergingSeg = mergingSeg;
        this.mergedSeg = mergedSeg;
        this.kylinConfig = kylinConfig;
        this.init();
    }

    private void init() {
        this.newKeyBodyBuf = new byte[16640];
        this.newKeyBuf = ByteArray.allocate(16640);
        this.rowKeySplitter = new RowKeySplitter(this.mergingSeg);
        this.rowKeyEncoderProvider = new RowKeyEncoderProvider(this.mergedSeg);
        this.measureDescs = this.cubeDesc.getMeasures();
        this.codec = new BufferedMeasureCodec(this.measureDescs);
        this.dictMeasures = Lists.newArrayList();
        this.oldDicts = Maps.newHashMap();
        this.newDicts = Maps.newHashMap();
        for (int i = 0; i < this.measureDescs.size(); ++i) {
            MeasureDesc measureDesc = this.measureDescs.get(i);
            MeasureType<?> measureType = measureDesc.getFunction().getMeasureType();
            List<TblColRef> columns = measureType.getColumnsNeedDictionary(measureDesc.getFunction());
            boolean needReEncode = false;
            for (TblColRef col : columns) {
                if (this.mergingSeg.getDictionary(col) == null) continue;
                this.oldDicts.put(col, this.mergingSeg.getDictionary(col));
                this.newDicts.put(col, this.mergedSeg.getDictionary(col));
                if (this.mergingSeg.getDictionary(col).equals(this.mergedSeg.getDictionary(col))) continue;
                needReEncode = true;
            }
            if (!needReEncode) continue;
            this.dictMeasures.add(Pair.newPair(i, measureType.newIngester()));
        }
        this.initialized = true;
    }

    public Pair<Text, Text> reEncode(Text key, Text value) throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        Object[] measureObjs = new Object[this.measureDescs.size()];
        if (this.dictMeasures.size() > 0) {
            this.codec.decode(ByteBuffer.wrap(value.getBytes(), 0, value.getLength()), measureObjs);
            for (Pair<Integer, MeasureIngester> pair : this.dictMeasures) {
                int i = pair.getFirst();
                MeasureIngester ingester = pair.getSecond();
                measureObjs[i] = ingester.reEncodeDictionary(measureObjs[i], this.measureDescs.get(i), this.oldDicts, this.newDicts);
            }
            ByteBuffer valueBuf = this.codec.encode(measureObjs);
            this.textValue.set(valueBuf.array(), 0, valueBuf.position());
            return Pair.newPair(this.processKey(key), this.textValue);
        }
        return Pair.newPair(this.processKey(key), value);
    }

    public Pair<Text, Object[]> reEncode2(Text key, Text value) throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Not initialized");
        }
        Object[] measureObjs = new Object[this.measureDescs.size()];
        this.codec.decode(ByteBuffer.wrap(value.getBytes(), 0, value.getLength()), measureObjs);
        if (this.dictMeasures.size() > 0) {
            for (Pair<Integer, MeasureIngester> pair : this.dictMeasures) {
                int i = pair.getFirst();
                MeasureIngester ingester = pair.getSecond();
                measureObjs[i] = ingester.reEncodeDictionary(measureObjs[i], this.measureDescs.get(i), this.oldDicts, this.newDicts);
            }
        }
        return Pair.newPair(this.processKey(key), measureObjs);
    }

    private Text processKey(Text key) throws IOException {
        long cuboidID = this.rowKeySplitter.split(key.getBytes());
        Cuboid cuboid = Cuboid.findForMandatory(this.cubeDesc, cuboidID);
        RowKeyEncoder rowkeyEncoder = this.rowKeyEncoderProvider.getRowkeyEncoder(cuboid);
        ByteArray[] splittedByteses = this.rowKeySplitter.getSplitBuffers();
        int bufOffset = 0;
        int bodySplitOffset = this.rowKeySplitter.getBodySplitOffset();
        for (int i = 0; i < cuboid.getColumns().size(); ++i) {
            int useSplit = i + bodySplitOffset;
            TblColRef col = cuboid.getColumns().get(i);
            if (this.cubeDesc.getRowkey().isUseDictionary(col)) {
                DictionaryManager dictMgr = DictionaryManager.getInstance(this.kylinConfig);
                Dictionary<String> mergedDict = dictMgr.getDictionary(this.mergedSeg.getDictResPath(col));
                if (mergedDict == null) continue;
                if (this.mergingSeg.getDictionary(col) == null) {
                    BytesUtil.writeUnsigned(mergedDict.nullId(), this.newKeyBodyBuf, bufOffset, mergedDict.getSizeOfId());
                    bufOffset += mergedDict.getSizeOfId();
                    continue;
                }
                Dictionary<String> sourceDict = dictMgr.getDictionary(this.mergingSeg.getDictResPath(col));
                while (sourceDict.getSizeOfValue() > this.newKeyBodyBuf.length - bufOffset || mergedDict.getSizeOfValue() > this.newKeyBodyBuf.length - bufOffset || mergedDict.getSizeOfId() > this.newKeyBodyBuf.length - bufOffset) {
                    byte[] oldBuf = this.newKeyBodyBuf;
                    this.newKeyBodyBuf = new byte[2 * this.newKeyBodyBuf.length];
                    System.arraycopy(oldBuf, 0, this.newKeyBodyBuf, 0, oldBuf.length);
                }
                int idInSourceDict = BytesUtil.readUnsigned(splittedByteses[useSplit].array(), splittedByteses[useSplit].offset(), splittedByteses[useSplit].length());
                String v = sourceDict.getValueFromId(idInSourceDict);
                int idInMergedDict = v == null ? mergedDict.nullId() : mergedDict.getIdFromValue(v);
                BytesUtil.writeUnsigned(idInMergedDict, this.newKeyBodyBuf, bufOffset, mergedDict.getSizeOfId());
                bufOffset += mergedDict.getSizeOfId();
                continue;
            }
            while (splittedByteses[useSplit].length() > this.newKeyBodyBuf.length - bufOffset) {
                byte[] oldBuf = this.newKeyBodyBuf;
                this.newKeyBodyBuf = new byte[2 * this.newKeyBodyBuf.length];
                System.arraycopy(oldBuf, 0, this.newKeyBodyBuf, 0, oldBuf.length);
            }
            System.arraycopy(splittedByteses[useSplit].array(), splittedByteses[useSplit].offset(), this.newKeyBodyBuf, bufOffset, splittedByteses[useSplit].length());
            bufOffset += splittedByteses[useSplit].length();
        }
        int fullKeySize = rowkeyEncoder.getBytesLength();
        while (this.newKeyBuf.array().length < fullKeySize) {
            this.newKeyBuf = new ByteArray(this.newKeyBuf.length() * 2);
        }
        this.newKeyBuf.setLength(fullKeySize);
        rowkeyEncoder.encode(new ByteArray(this.newKeyBodyBuf, 0, bufOffset), this.newKeyBuf);
        byte[] resultKey = new byte[fullKeySize];
        System.arraycopy(this.newKeyBuf.array(), 0, resultKey, 0, fullKeySize);
        return new Text(resultKey);
    }
}

