/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.DictionaryInfoSerializer;
import org.apache.kylin.dict.DictionaryManager;
import org.apache.kylin.engine.mr.common.CubeJobLockUtil;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveDictStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(SaveDictStep.class);

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        logger.info("job {} start to run SaveDictStep", (Object)this.getJobFlowJobId());
        CubeManager mgr = CubeManager.getInstance(context.getConfig());
        DictionaryManager dictManager = DictionaryManager.getInstance(context.getConfig());
        CubeInstance cube = mgr.getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        CubeInstance cubeForUpdate = cube.latestCopyForWrite();
        CubeSegment cubeSeg = cubeForUpdate.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        CubeDesc cubeDesc = cube.getDescriptor();
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        DictionaryInfoSerializer serializer = DictionaryInfoSerializer.FULL_SERIALIZER;
        Set<TblColRef> colRefs = cubeDesc.getAllColumnsNeedDictionaryBuilt();
        HashMap<String, TblColRef> colRefMap = Maps.newHashMap();
        for (TblColRef colRef : colRefs) {
            colRefMap.put(colRef.getName(), colRef);
        }
        try {
            FileStatus[] files;
            Path dictsDirPath = new Path(CubingExecutableUtil.getDictsPath(this.getParams()));
            Configuration hadoopConf = HadoopUtil.getCurrentConfiguration();
            FileSystem fs = FileSystem.get((Configuration)hadoopConf);
            if (!fs.exists(dictsDirPath)) {
                throw new IOException("DictsFilePath " + dictsDirPath + " does not exists");
            }
            if (!fs.isDirectory(dictsDirPath)) {
                throw new IOException("DictsFilePath " + dictsDirPath + " is not a directory");
            }
            RemoteIterator outputs = fs.listFiles(dictsDirPath, true);
            while (outputs.hasNext()) {
                logger.info("mapreduce out put file: {}", (Object)((LocatedFileStatus)outputs.next()).getPath());
            }
            for (FileStatus file : files = fs.listStatus(dictsDirPath, new PathFilter(){

                public boolean accept(Path path) {
                    return path.getName().contains("-");
                }
            })) {
                try (SequenceFile.Reader reader = new SequenceFile.Reader(fs, file.getPath(), conf);){
                    Text colName = new Text();
                    Text dictInfo = new Text();
                    while (reader.next((Writable)colName, (Writable)dictInfo)) {
                        TblColRef colRef = (TblColRef)colRefMap.get(colName.toString());
                        if (colRef == null) {
                            throw new IllegalArgumentException("Invalid column name " + colName + " or it need not build dictionary!");
                        }
                        DictionaryInfo dictionaryInfo = serializer.deserialize(new DataInputStream(new ByteArrayInputStream(dictInfo.getBytes())));
                        Dictionary<String> dict = dictionaryInfo.getDictionaryObject();
                        if (dict != null) {
                            dictionaryInfo = dictManager.trySaveNewDict(dict, dictionaryInfo);
                            cubeSeg.putDictResPath(colRef, dictionaryInfo.getResourcePath());
                            if (cubeSeg.getRowkeyStats() != null) {
                                cubeSeg.getRowkeyStats().add(new Object[]{colRef.getName(), dict.getSize(), dict.getSizeOfId()});
                                continue;
                            }
                            logger.error("rowkey_stats field not found!");
                            continue;
                        }
                        logger.error("dictionary of column {} not found! ", (Object)colRef.getName());
                    }
                }
            }
            CubeUpdate cubeBuilder = new CubeUpdate(cubeForUpdate);
            cubeBuilder.setToUpdateSegs(cubeSeg);
            mgr.updateCube(cubeBuilder);
            fs.delete(dictsDirPath, true);
            for (FileStatus fileElem : files) {
                fs.delete(fileElem.getPath(), true);
            }
            if (this.getIsNeedReleaseLock()) {
                this.releaseLock();
            }
            return new ExecuteResult();
        }
        catch (IOException e) {
            logger.error("fail to save cuboid dictionaries", e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void cleanup() throws ExecuteException {
        super.cleanup();
    }

    public void setIsNeedReleaseLock(Boolean isNeedReleaseLock) {
        this.setParam("isNeedReleaseLock", String.valueOf(isNeedReleaseLock));
    }

    public boolean getIsNeedReleaseLock() {
        String isNeedReleaseLock = this.getParam("isNeedReleaseLock");
        return Strings.isNullOrEmpty(isNeedReleaseLock) ? false : Boolean.parseBoolean(isNeedReleaseLock);
    }

    public void setLockPathName(String pathName) {
        this.setParam("lockPathName", pathName);
    }

    public String getLockPathName() {
        return this.getParam("lockPathName");
    }

    public void setJobFlowJobId(String jobId) {
        this.setParam("jobFlowJobId", jobId);
    }

    public String getJobFlowJobId() {
        return this.getParam("jobFlowJobId");
    }

    private void releaseLock() {
        DistributedLock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
        String parentLockPath = this.getCubeJobLockParentPathName();
        String ephemeralLockPath = this.getEphemeralLockPathName();
        if (lock.isLocked(this.getCubeJobLockPathName())) {
            lock.purgeLocks(parentLockPath);
            logger.info("{} unlock full lock path :{} success", (Object)this.getId(), (Object)parentLockPath);
        }
        if (lock.isLocked(ephemeralLockPath)) {
            lock.purgeLocks(ephemeralLockPath);
            logger.info("{} unlock full lock path :{} success", (Object)this.getId(), (Object)ephemeralLockPath);
        }
    }

    private String getEphemeralLockPathName() {
        String pathName = this.getLockPathName();
        if (Strings.isNullOrEmpty(pathName)) {
            throw new IllegalArgumentException("cube job lock path name is null");
        }
        return CubeJobLockUtil.getEphemeralLockPath(pathName);
    }

    private String getCubeJobLockPathName() {
        String pathName = this.getLockPathName();
        if (Strings.isNullOrEmpty(pathName)) {
            throw new IllegalArgumentException("cube job lock path name is null");
        }
        String flowJobId = this.getJobFlowJobId();
        if (Strings.isNullOrEmpty(flowJobId)) {
            throw new IllegalArgumentException("cube job lock path flowJobId is null");
        }
        return CubeJobLockUtil.getLockPath(pathName, flowJobId);
    }

    private String getCubeJobLockParentPathName() {
        String pathName = this.getLockPathName();
        if (Strings.isNullOrEmpty(pathName)) {
            throw new IllegalArgumentException(" create mr hive dict lock path name is null");
        }
        return CubeJobLockUtil.getLockPath(pathName, null);
    }
}

