/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableDesc;
import org.apache.kylin.engine.IBatchCubingEngine;
import org.apache.kylin.engine.mr.BatchOptimizeJobBuilder2;
import org.apache.kylin.engine.spark.ISparkInput;
import org.apache.kylin.engine.spark.ISparkOutput;
import org.apache.kylin.engine.spark.SparkBatchCubingJobBuilder2;
import org.apache.kylin.engine.spark.SparkBatchMergeJobBuilder2;
import org.apache.kylin.engine.spark.SparkBatchOptimizeJobBuilder2;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;

public class SparkBatchCubingEngine2
implements IBatchCubingEngine {
    @Override
    public IJoinedFlatTableDesc getJoinedFlatTableDesc(CubeDesc cubeDesc) {
        return new CubeJoinedFlatTableDesc(cubeDesc);
    }

    @Override
    public IJoinedFlatTableDesc getJoinedFlatTableDesc(CubeSegment newSegment) {
        return new CubeJoinedFlatTableDesc(newSegment);
    }

    @Override
    public DefaultChainedExecutable createBatchCubingJob(CubeSegment newSegment, String submitter, Integer priorityOffset) {
        return new SparkBatchCubingJobBuilder2(newSegment, submitter, priorityOffset).build();
    }

    @Override
    public DefaultChainedExecutable createBatchMergeJob(CubeSegment mergeSegment, String submitter) {
        return new SparkBatchMergeJobBuilder2(mergeSegment, submitter).build();
    }

    @Override
    public DefaultChainedExecutable createBatchOptimizeJob(CubeSegment optimizeSegment, String submitter) {
        if (optimizeSegment.getConfig().isSparkOptimizeCubeViaSparkEnable()) {
            return new SparkBatchOptimizeJobBuilder2(optimizeSegment, submitter).build();
        }
        return new BatchOptimizeJobBuilder2(optimizeSegment, submitter).build();
    }

    @Override
    public Class<?> getSourceInterface() {
        return ISparkInput.class;
    }

    @Override
    public Class<?> getStorageInterface() {
        return ISparkOutput.class;
    }
}

