/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringSplitter;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.BatchCubingJobBuilder2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.CubeStatsReader;
import org.apache.kylin.engine.mr.common.SerializableConfiguration;
import org.apache.kylin.engine.mr.steps.SegmentReEncoder;
import org.apache.kylin.engine.spark.KylinSparkJobListener;
import org.apache.kylin.engine.spark.SparkUtil;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureAggregators;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkCubingMerge
extends AbstractApplication
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(SparkCubingMerge.class);
    public static final Option OPTION_CUBE_NAME;
    public static final Option OPTION_SEGMENT_ID;
    public static final Option OPTION_META_URL;
    public static final Option OPTION_OUTPUT_PATH;
    public static final Option OPTION_INPUT_PATH;
    private Options options = new Options();
    private String cubeName;
    private String metaUrl;

    public SparkCubingMerge() {
        this.options.addOption(OPTION_META_URL);
        this.options.addOption(OPTION_CUBE_NAME);
        this.options.addOption(OPTION_SEGMENT_ID);
        this.options.addOption(OPTION_INPUT_PATH);
        this.options.addOption(OPTION_OUTPUT_PATH);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.metaUrl = optionsHelper.getOptionValue(OPTION_META_URL);
        this.cubeName = optionsHelper.getOptionValue(OPTION_CUBE_NAME);
        String inputPath = optionsHelper.getOptionValue(OPTION_INPUT_PATH);
        String segmentId = optionsHelper.getOptionValue(OPTION_SEGMENT_ID);
        String outputPath = optionsHelper.getOptionValue(OPTION_OUTPUT_PATH);
        Class[] kryoClassArray = new Class[]{Class.forName("scala.reflect.ClassTag$$anon$1")};
        SparkConf conf = new SparkConf().setAppName("Merge segments for cube:" + this.cubeName + ", segment " + segmentId);
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.set("spark.kryo.registrator", "org.apache.kylin.engine.spark.KylinKryoRegistrator");
        conf.set("spark.kryo.registrationRequired", "true").registerKryoClasses(kryoClassArray);
        try (JavaSparkContext sc = new JavaSparkContext(conf);){
            CubeSegment sourceSegment;
            SparkUtil.modifySparkHadoopConfiguration(sc.sc(), AbstractHadoopJob.loadKylinConfigFromHdfs(new SerializableConfiguration(sc.hadoopConfiguration()), this.metaUrl));
            KylinSparkJobListener jobListener = new KylinSparkJobListener();
            sc.sc().addSparkListener((SparkListenerInterface)jobListener);
            HadoopUtil.deletePath(sc.hadoopConfiguration(), new Path(outputPath));
            final SerializableConfiguration sConf = new SerializableConfiguration(sc.hadoopConfiguration());
            KylinConfig envConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, this.metaUrl);
            CubeInstance cubeInstance = CubeManager.getInstance(envConfig).getCube(this.cubeName);
            CubeDesc cubeDesc = CubeDescManager.getInstance(envConfig).getCubeDesc(cubeInstance.getDescName());
            CubeSegment cubeSegment = cubeInstance.getSegmentById(segmentId);
            CubeStatsReader cubeStatsReader = new CubeStatsReader(cubeSegment, envConfig);
            logger.info("Input path: {}", (Object)inputPath);
            logger.info("Output path: {}", (Object)outputPath);
            Job job = Job.getInstance((Configuration)sConf.get());
            SparkUtil.setHadoopConfForCuboid(job, cubeSegment, this.metaUrl);
            final MeasureAggregators aggregators = new MeasureAggregators(cubeDesc.getMeasures());
            Function2<Object[], Object[], Object[]> reduceFunction = new Function2<Object[], Object[], Object[]>(){

                public Object[] call(Object[] input1, Object[] input2) throws Exception {
                    Object[] measureObjs = new Object[input1.length];
                    aggregators.aggregate(input1, input2, measureObjs);
                    return measureObjs;
                }
            };
            PairFunction<Tuple2<Text, Object[]>, Text, Text> convertTextFunction = new PairFunction<Tuple2<Text, Object[]>, Text, Text>(){
                private volatile transient boolean initialized = false;
                BufferedMeasureCodec codec;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public Tuple2<Text, Text> call(Tuple2<Text, Object[]> tuple2) throws Exception {
                    block14: {
                        if (this.initialized) break;
                        Class<SparkCubingMerge> clazz = SparkCubingMerge.class;
                        // MONITORENTER : org.apache.kylin.engine.spark.SparkCubingMerge.class
                        if (this.initialized) break;
                        Class<SparkCubingMerge> clazz2 = SparkCubingMerge.class;
                        // MONITORENTER : org.apache.kylin.engine.spark.SparkCubingMerge.class
                        if (!this.initialized) {
                            Throwable throwable;
                            KylinConfig.SetAndUnsetThreadLocalConfig autoUnset;
                            block15: {
                                KylinConfig kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(sConf, SparkCubingMerge.this.metaUrl);
                                autoUnset = KylinConfig.setAndUnsetThreadLocalConfig(kylinConfig);
                                throwable = null;
                                CubeDesc desc = CubeDescManager.getInstance(kylinConfig).getCubeDesc(SparkCubingMerge.this.cubeName);
                                this.codec = new BufferedMeasureCodec(desc.getMeasures());
                                this.initialized = true;
                                if (autoUnset == null) break block14;
                                if (throwable == null) break block15;
                                try {
                                    autoUnset.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block14;
                            }
                            autoUnset.close();
                            break block14;
                            catch (Throwable throwable3) {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (autoUnset == null) throw throwable4;
                                    if (throwable == null) {
                                        autoUnset.close();
                                        throw throwable4;
                                    }
                                    try {
                                        autoUnset.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                            }
                        }
                    }
                    // MONITOREXIT : clazz2
                    // MONITOREXIT : clazz
                    ByteBuffer valueBuf = this.codec.encode((Object[])tuple2._2());
                    byte[] encodedBytes = new byte[valueBuf.position()];
                    System.arraycopy(valueBuf.array(), 0, encodedBytes, 0, valueBuf.position());
                    return new Tuple2(tuple2._1(), (Object)new Text(encodedBytes));
                }
            };
            int totalLevels = cubeSegment.getCuboidScheduler().getBuildLevel();
            String[] inputFolders = StringSplitter.split(inputPath, ",");
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            boolean isLegacyMode = false;
            for (String inputFolder : inputFolders) {
                Path baseCuboidPath = new Path(BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(inputFolder, 0));
                if (fs.exists(baseCuboidPath)) continue;
                isLegacyMode = true;
                break;
            }
            if (isLegacyMode) {
                ArrayList<JavaPairRDD> mergingSegs = Lists.newArrayListWithExpectedSize(inputFolders.length);
                for (int i = 0; i < inputFolders.length; ++i) {
                    String path = inputFolders[i];
                    JavaPairRDD segRdd = SparkUtil.parseInputPath(path, fs, sc, Text.class, Text.class);
                    sourceSegment = this.findSourceSegment(path, cubeInstance);
                    JavaPairRDD newEcoddedRdd = segRdd.mapToPair((PairFunction)new ReEncodeCuboidFunction(this.cubeName, sourceSegment.getUuid(), cubeSegment.getUuid(), this.metaUrl, sConf));
                    mergingSegs.add(newEcoddedRdd);
                }
                FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
                sc.union(mergingSegs.toArray(new JavaPairRDD[mergingSegs.size()])).reduceByKey((Function2)reduceFunction, SparkUtil.estimateTotalPartitionNum(cubeStatsReader, envConfig)).mapToPair((PairFunction)convertTextFunction).saveAsNewAPIHadoopDataset(job.getConfiguration());
            } else {
                for (int level = 0; level <= totalLevels; ++level) {
                    ArrayList<JavaPairRDD> mergingSegs = Lists.newArrayList();
                    for (int i = 0; i < inputFolders.length; ++i) {
                        String path = inputFolders[i];
                        sourceSegment = this.findSourceSegment(path, cubeInstance);
                        String cuboidInputPath = BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(path, level);
                        JavaPairRDD segRdd = sc.sequenceFile(cuboidInputPath, Text.class, Text.class);
                        JavaPairRDD newEcoddedRdd = segRdd.mapToPair((PairFunction)new ReEncodeCuboidFunction(this.cubeName, sourceSegment.getUuid(), cubeSegment.getUuid(), this.metaUrl, sConf));
                        mergingSegs.add(newEcoddedRdd);
                    }
                    String cuboidOutputPath = BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(outputPath, level);
                    FileOutputFormat.setOutputPath((Job)job, (Path)new Path(cuboidOutputPath));
                    sc.union(mergingSegs.toArray(new JavaPairRDD[mergingSegs.size()])).reduceByKey((Function2)reduceFunction, SparkUtil.estimateLayerPartitionNum(level, cubeStatsReader, envConfig)).mapToPair((PairFunction)convertTextFunction).saveAsNewAPIHadoopDataset(job.getConfiguration());
                }
            }
            logger.info("HDFS: Number of bytes written={}", (Object)jobListener.metrics.getBytesWritten());
        }
    }

    private CubeSegment findSourceSegment(String filePath, CubeInstance cube) {
        String jobID = JobBuilderSupport.extractJobIDFromPath(filePath);
        return CubeInstance.findSegmentWithJobId(jobID, cube);
    }

    static {
        OptionBuilder.withArgName((String)"cubename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Name");
        OPTION_CUBE_NAME = OptionBuilder.create((String)"cubename");
        OptionBuilder.withArgName((String)"segment");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cube Segment Id");
        OPTION_SEGMENT_ID = OptionBuilder.create((String)"segmentId");
        OptionBuilder.withArgName((String)"metaUrl");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HDFS metadata url");
        OPTION_META_URL = OptionBuilder.create((String)"metaUrl");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"HFile output path");
        OPTION_OUTPUT_PATH = OptionBuilder.create((String)"output");
        OptionBuilder.withArgName((String)"input");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Cuboid files PATH");
        OPTION_INPUT_PATH = OptionBuilder.create((String)"input");
    }

    static class ReEncodeCuboidFunction
    implements PairFunction<Tuple2<Text, Text>, Text, Object[]> {
        private volatile transient boolean initialized = false;
        private String cubeName;
        private String sourceSegmentId;
        private String mergedSegmentId;
        private String metaUrl;
        private SerializableConfiguration conf;
        private transient KylinConfig kylinConfig;
        private transient SegmentReEncoder segmentReEncoder = null;

        ReEncodeCuboidFunction(String cubeName, String sourceSegmentId, String mergedSegmentId, String metaUrl, SerializableConfiguration conf) {
            this.cubeName = cubeName;
            this.sourceSegmentId = sourceSegmentId;
            this.mergedSegmentId = mergedSegmentId;
            this.metaUrl = metaUrl;
            this.conf = conf;
        }

        private void init() {
            this.kylinConfig = AbstractHadoopJob.loadKylinConfigFromHdfs(this.conf, this.metaUrl);
            CubeInstance cube = CubeManager.getInstance(this.kylinConfig).getCube(this.cubeName);
            CubeDesc cubeDesc = CubeDescManager.getInstance(this.kylinConfig).getCubeDesc(cube.getDescName());
            CubeSegment sourceSeg = cube.getSegmentById(this.sourceSegmentId);
            CubeSegment mergedSeg = cube.getSegmentById(this.mergedSegmentId);
            this.segmentReEncoder = new SegmentReEncoder(cubeDesc, sourceSeg, mergedSeg, this.kylinConfig);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public Tuple2<Text, Object[]> call(Tuple2<Text, Text> textTextTuple2) throws Exception {
            if (!this.initialized) {
                Class<ReEncodeCuboidFunction> clazz = ReEncodeCuboidFunction.class;
                // MONITORENTER : org.apache.kylin.engine.spark.SparkCubingMerge$ReEncodeCuboidFunction.class
                if (!this.initialized) {
                    this.init();
                    this.initialized = true;
                }
                // MONITOREXIT : clazz
            }
            Pair<Text, Object[]> encodedPair = this.segmentReEncoder.reEncode2((Text)textTextTuple2._1, (Text)textTextTuple2._2);
            return new Tuple2((Object)encodedPair.getFirst(), (Object)encodedPair.getSecond());
        }
    }
}

