/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.common;

import java.io.IOException;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.job.common.PatternedLogger;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.exception.ShellException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.impl.threadpool.IJobRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellExecutable
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(ShellExecutable.class);
    private static final String CMD = "cmd";

    @Override
    protected ExecuteResult doWork(ExecutableContext context, IJobRunner jobRunner) throws ExecuteException {
        try {
            logger.info("executing:" + this.getCmd());
            PatternedLogger patternedLogger = new PatternedLogger(logger);
            Pair<Integer, String> result = context.getConfig().getCliCommandExecutor().execute(this.getCmd(), patternedLogger);
            this.getManager().addJobInfo(this.getId(), patternedLogger.getInfo());
            return result.getFirst() == 0 ? new ExecuteResult(ExecuteResult.State.SUCCEED, result.getSecond()) : ExecuteResult.createFailed(new ShellException(result.getSecond()));
        }
        catch (IOException e) {
            logger.error("job:" + this.getId() + " execute finished with exception", e);
            return ExecuteResult.createError(e);
        }
    }

    public void setCmd(String cmd) {
        this.setParam(CMD, cmd);
    }

    public String getCmd() {
        return this.getParam(CMD);
    }
}

