/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.shaded.org.roaringbitmap;

import org.apache.kylin.job.shaded.org.roaringbitmap.ArrayContainer;
import org.apache.kylin.job.shaded.org.roaringbitmap.PeekableShortIterator;
import org.apache.kylin.job.shaded.org.roaringbitmap.Util;

final class ArrayContainerShortIterator
implements PeekableShortIterator {
    int pos;
    ArrayContainer parent;

    ArrayContainerShortIterator() {
    }

    ArrayContainerShortIterator(ArrayContainer p) {
        this.wrap(p);
    }

    @Override
    public void advanceIfNeeded(short minval) {
        this.pos = Util.advanceUntil(this.parent.content, this.pos - 1, this.parent.cardinality, minval);
    }

    @Override
    public PeekableShortIterator clone() {
        try {
            return (PeekableShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.parent.cardinality;
    }

    @Override
    public short next() {
        return this.parent.content[this.pos++];
    }

    @Override
    public int nextAsInt() {
        return Util.toIntUnsigned(this.parent.content[this.pos++]);
    }

    @Override
    public short peekNext() {
        return this.parent.content[this.pos];
    }

    @Override
    public void remove() {
        this.parent.remove((short)(this.pos - 1));
        --this.pos;
    }

    void wrap(ArrayContainer p) {
        this.parent = p;
        this.pos = 0;
    }
}

