/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.CaseInsensitiveStringSet;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableSet;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class TableACL
extends RootPersistentEntity {
    @JsonProperty
    private TableACLEntry userTableBlackList = new TableACLEntry();
    @JsonProperty
    private TableACLEntry groupTableBlackList = new TableACLEntry();
    private String project;

    void init(String project) {
        this.project = project;
    }

    @Override
    public String resourceName() {
        return this.project;
    }

    public Set<String> getTableBlackList(String username, Set<String> groups) {
        TreeSet<String> tableBlackList = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        tableBlackList.addAll(this.userTableBlackList.getTableBlackList(username));
        for (String group : groups) {
            tableBlackList.addAll(this.groupTableBlackList.getTableBlackList(group));
        }
        return tableBlackList;
    }

    private TableACLEntry currentEntry(String type) {
        if (type.equalsIgnoreCase("user")) {
            return this.userTableBlackList;
        }
        return this.groupTableBlackList;
    }

    public List<String> getNoAccessList(String table, String type) {
        return this.currentEntry(type).getNoAccessList(table);
    }

    public List<String> getCanAccessList(String table, Set<String> allIdentifiers, String type) {
        return this.currentEntry(type).getCanAccessList(table, allIdentifiers);
    }

    public Set<String> getBlockedTablesByUser(String username, String type) {
        return this.currentEntry(type).get(username) == null ? Sets.newHashSet() : ((TableBlackList)this.currentEntry(type).get(username)).getTables();
    }

    public TableACL add(String name, String table, String type) {
        this.currentEntry(type).add(name, table);
        return this;
    }

    public TableACL delete(String name, String table, String type) {
        this.currentEntry(type).delete(name, table);
        return this;
    }

    public TableACL delete(String name, String type) {
        this.currentEntry(type).delete(name);
        return this;
    }

    TableACL deleteByTbl(String table) {
        this.userTableBlackList.deleteByTbl(table);
        this.groupTableBlackList.deleteByTbl(table);
        return this;
    }

    public boolean contains(String name, String type) {
        return this.currentEntry(type).containsKey(name);
    }

    public int size() {
        return this.userTableBlackList.size() + this.groupTableBlackList.size();
    }

    public int size(String type) {
        return this.currentEntry(type).size();
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class TableBlackList {
        @JsonProperty
        private CaseInsensitiveStringSet tables = new CaseInsensitiveStringSet();

        private TableBlackList() {
        }

        private boolean isEmpty() {
            return this.tables.isEmpty();
        }

        private boolean contains(String s) {
            return this.tables.contains(s);
        }

        private void addTbl(String s) {
            this.tables.add(s);
        }

        private void removeTbl(String s) {
            this.tables.remove(s);
        }

        private Set<String> getTables() {
            return ImmutableSet.copyOf(this.tables);
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class TableACLEntry
    extends HashMap<String, TableBlackList> {
        private TableACLEntry() {
        }

        private void add(String name, String table) {
            TableBlackList tableBlackList = (TableBlackList)super.get(name);
            if (tableBlackList == null) {
                tableBlackList = new TableBlackList();
                super.put(name, tableBlackList);
            }
            this.validateACLNotExists(name, table, tableBlackList);
            tableBlackList.addTbl(table);
        }

        private void delete(String name, String table) {
            this.validateACLExists(name, table);
            TableBlackList tableBlackList = (TableBlackList)super.get(name);
            tableBlackList.removeTbl(table);
            if (tableBlackList.isEmpty()) {
                super.remove(name);
            }
        }

        private void delete(String username) {
            this.validateACLExists(username);
            super.remove(username);
        }

        private void deleteByTbl(String table) {
            Iterator it = super.entrySet().iterator();
            while (it.hasNext()) {
                TableBlackList tableBlackList = (TableBlackList)it.next().getValue();
                tableBlackList.removeTbl(table);
                if (!tableBlackList.isEmpty()) continue;
                it.remove();
            }
        }

        private Set<String> getTableBlackList(String name) {
            TableBlackList tableBlackList = (TableBlackList)super.get(name);
            if (tableBlackList == null) {
                tableBlackList = new TableBlackList();
            }
            return tableBlackList.getTables();
        }

        private List<String> getNoAccessList(String table) {
            ArrayList<String> results = new ArrayList<String>();
            for (String identifiers : super.keySet()) {
                if (!((TableBlackList)super.get(identifiers)).contains(table)) continue;
                results.add(identifiers);
            }
            return results;
        }

        private List<String> getCanAccessList(String table, Set<String> allIdentifiers) {
            ArrayList<String> list = Lists.newArrayList(allIdentifiers);
            List<String> blocked = this.getNoAccessList(table);
            list.removeAll(blocked);
            return list;
        }

        private void validateACLExists(String username) {
            if (super.get(username) == null || ((TableBlackList)super.get(username)).isEmpty()) {
                throw new RuntimeException("Operation fail, can not grant user table query permission.User:" + username + " already has permission!");
            }
        }

        private void validateACLNotExists(String username, String table, TableBlackList tableBlackList) {
            if (tableBlackList.contains(table)) {
                throw new RuntimeException("Operation fail, can not revoke user's table query permission.Table ACL " + table + ":" + username + " already exists!");
            }
        }

        private void validateACLExists(String name, String table) {
            if (super.get(name) == null || !((TableBlackList)super.get(name)).contains(table)) {
                throw new RuntimeException("Operation fail, can not grant user table query permission.Table ACL " + table + ":" + name + " is not found!");
            }
        }
    }
}

