/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.adhoc;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.shaded.org.apache.commons.dbcp.BasicDataSource;

public class JdbcPushDownConnectionManager {
    private static volatile JdbcPushDownConnectionManager manager = null;
    private final BasicDataSource dataSource = new BasicDataSource();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static JdbcPushDownConnectionManager getConnectionManager(String id) throws ClassNotFoundException {
        if (manager != null && id == null) return manager;
        Class<JdbcPushDownConnectionManager> clazz = JdbcPushDownConnectionManager.class;
        synchronized (JdbcPushDownConnectionManager.class) {
            if (manager != null && id == null) return manager;
            manager = new JdbcPushDownConnectionManager(KylinConfig.getInstanceFromEnv(), id);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return manager;
        }
    }

    private JdbcPushDownConnectionManager(KylinConfig config, String id) throws ClassNotFoundException {
        Class.forName(config.getJdbcDriverClass(id));
        this.dataSource.setDriverClassName(config.getJdbcDriverClass(id));
        this.dataSource.setUrl(config.getJdbcUrl(id));
        this.dataSource.setUsername(config.getJdbcUsername(id));
        this.dataSource.setPassword(config.getJdbcPassword(id));
        this.dataSource.setMaxActive(config.getPoolMaxTotal(id));
        this.dataSource.setMaxIdle(config.getPoolMaxIdle(id));
        this.dataSource.setMinIdle(config.getPoolMinIdle(id));
        this.dataSource.setTestOnBorrow(true);
        this.dataSource.setValidationQuery("select 1");
        this.dataSource.setRemoveAbandoned(true);
        this.dataSource.setRemoveAbandonedTimeout(300);
    }

    public void close() {
        try {
            this.dataSource.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

