/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.calcite;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystemImpl;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class KylinRelDataTypeSystem
extends RelDataTypeSystemImpl {
    @Override
    public RelDataType deriveSumType(RelDataTypeFactory typeFactory, RelDataType argumentType) {
        if (argumentType instanceof BasicSqlType) {
            switch (argumentType.getSqlTypeName()) {
                case INTEGER: 
                case SMALLINT: 
                case TINYINT: {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), argumentType.isNullable());
                }
                case DECIMAL: {
                    return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.DECIMAL, 19, argumentType.getScale()), argumentType.isNullable());
                }
            }
        }
        return argumentType;
    }

    @Override
    public int getMaxNumericPrecision() {
        return 38;
    }
}

