/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.enumerable.EnumerableAggregate;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.fun.SqlCountAggFunction;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.SqlSumAggFunction;
import org.apache.calcite.sql.fun.SqlSumEmptyIsZeroAggFunction;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.ParamAsMeasureCount;
import org.apache.kylin.metadata.expression.CaseTupleExpression;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.ConstantTupleExpression;
import org.apache.kylin.metadata.expression.ExpressionColCollector;
import org.apache.kylin.metadata.expression.ExpressionCountDistributor;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.CountDistinctExpressionDynamicFunctionDesc;
import org.apache.kylin.metadata.model.DynamicFunctionDesc;
import org.apache.kylin.metadata.model.ExpressionDynamicFunctionDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.StdDevSumFunctionDesc;
import org.apache.kylin.metadata.model.SumExpressionDynamicFunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.KylinAggregateCall;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.schema.OLAPTable;

public class OLAPAggregateRel
extends Aggregate
implements OLAPRel {
    static final Map<String, String> AGGR_FUNC_MAP = new HashMap<String, String>();
    static final Map<String, Integer> AGGR_FUNC_PARAM_AS_MEASURE_MAP = new HashMap<String, Integer>();
    OLAPContext context;
    ColumnRowType columnRowType;
    private boolean afterAggregate;
    private Map<Integer, AggregateCall> hackAggCalls;
    private List<AggregateCall> rewriteAggCalls;
    private List<Set<TblColRef>> groups;
    private List<FunctionDesc> aggregations;
    private boolean rewriting;

    public OLAPAggregateRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traits, child, indicator, groupSet, groupSets, aggCalls);
        Preconditions.checkArgument(this.getConvention() == OLAPRel.CONVENTION);
        this.afterAggregate = false;
        this.rewriteAggCalls = aggCalls;
        this.rowType = this.getRowType();
    }

    static String getSqlFuncName(AggregateCall aggCall) {
        String sqlName = aggCall.getAggregation().getName();
        if (aggCall.isDistinct()) {
            sqlName = sqlName + "_DISTINCT";
        }
        return sqlName;
    }

    public static String getAggrFuncName(AggregateCall aggCall) {
        String sqlName = OLAPAggregateRel.getSqlFuncName(aggCall);
        String funcName = AGGR_FUNC_MAP.get(sqlName);
        if (funcName == null) {
            throw new IllegalStateException("Non-support aggregation " + sqlName);
        }
        return funcName;
    }

    @Override
    public Aggregate copy(RelTraitSet traitSet, RelNode input, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        try {
            return new OLAPAggregateRel(this.getCluster(), traitSet, input, indicator, groupSet, groupSets, aggCalls);
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException("Can't create OLAPAggregateRel!", e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = this.getGroupType() == Aggregate.Group.SIMPLE ? super.computeSelfCost(planner, mq).multiplyBy(0.05) : super.computeSelfCost(planner, mq).multiplyBy(0.05).plus(planner.getCost(this.getInput(), mq)).multiplyBy((double)this.groupSets.size() * 1.5);
        return cost;
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.fixSharedOlapTableScan(this);
        implementor.visitChild(this.getInput(), this);
        this.context = implementor.getContext();
        this.columnRowType = this.buildColumnRowType();
        this.afterAggregate = this.context.afterAggregate;
        if (!this.afterAggregate) {
            ArrayList<TblColRef> colRefList = Lists.newArrayList();
            for (Set<TblColRef> colRefSet : this.groups) {
                colRefList.addAll(colRefSet);
            }
            this.addToContextGroupBy(colRefList);
            this.context.aggregations.addAll(this.aggregations);
            this.context.aggrOutCols.addAll(this.columnRowType.getAllColumns().subList(this.groups.size(), this.columnRowType.getAllColumns().size()));
            this.context.afterAggregate = true;
            if (this.context.afterLimit) {
                this.context.limitPrecedesAggr = true;
            }
        } else {
            this.context.afterOuterAggregate = true;
            for (AggregateCall aggCall : this.aggCalls) {
                if (!aggCall.isDistinct()) continue;
                throw new IllegalStateException("Distinct count is only allowed in innermost sub-query.");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    ColumnRowType buildColumnRowType() {
        this.buildGroups();
        this.buildAggregations();
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>(this.rowType.getFieldCount());
        for (Set<TblColRef> set : this.groups) {
            String string = set.stream().map(TblColRef::getName).collect(Collectors.toList()).toString();
            TblColRef groupInnerCol = TblColRef.newInnerColumn(string, TblColRef.InnerDataTypeEnum.LITERAL);
            columns.add(groupInnerCol);
        }
        if (this.indicator) {
            HashSet<String> containedNames = Sets.newHashSet();
            for (Set<TblColRef> set : this.groups) {
                String base;
                String name = base = "i$" + set.stream().map(TblColRef::getName).collect(Collectors.toList());
                int i = 0;
                while (containedNames.contains(name)) {
                    name = base + "_" + i++;
                }
                containedNames.add(name);
                TblColRef indicatorCol = TblColRef.newInnerColumn(name, TblColRef.InnerDataTypeEnum.LITERAL);
                columns.add(indicatorCol);
            }
        }
        for (int i = 0; i < this.aggregations.size(); ++i) {
            void var5_16;
            FunctionDesc functionDesc = this.aggregations.get(i);
            if (functionDesc != null) {
                String string = functionDesc.getRewriteFieldName();
            } else {
                AggregateCall aggCall = this.rewriteAggCalls.get(i);
                int index = aggCall.getArgList().get(0);
                String string = OLAPAggregateRel.getSqlFuncName(aggCall) + "_" + inputColumnRowType.getColumnByIndex(index).getIdentity().replace('.', '_') + "_";
            }
            TblColRef aggOutCol = TblColRef.newInnerColumn((String)var5_16, TblColRef.InnerDataTypeEnum.LITERAL);
            aggOutCol.getColumnDesc().setId("" + (i + 1));
            columns.add(aggOutCol);
        }
        return new ColumnRowType(columns);
    }

    TblColRef buildRewriteColumn(FunctionDesc aggFunc) {
        if (!aggFunc.needRewriteField()) {
            throw new IllegalStateException("buildRewriteColumn on a aggrFunc that does not need rewrite " + aggFunc);
        }
        String colName = aggFunc.getRewriteFieldName();
        TblColRef colRef = this.context.firstTableScan.makeRewriteColumn(colName);
        return colRef;
    }

    void buildGroups() {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        this.groups = Lists.newArrayList();
        int i = this.getGroupSet().nextSetBit(0);
        while (i >= 0) {
            TupleExpression tupleExpression = inputColumnRowType.getTupleExpressionByIndex(i);
            if (!(this.context.groupByExpression || TupleExpression.ExpressionOperatorEnum.COLUMN.equals((Object)tupleExpression.getOperator()) && tupleExpression.getChildren().isEmpty())) {
                this.context.groupByExpression = true;
            }
            TblColRef groupOutCol = inputColumnRowType.getColumnByIndex(i);
            if (tupleExpression instanceof ColumnTupleExpression) {
                this.groups.add(Sets.newHashSet(((ColumnTupleExpression)tupleExpression).getColumn()));
            } else if (this.context.isDynamicColumnEnabled() && tupleExpression.ifForDynamicColumn()) {
                boolean ifPushDown;
                Pair<Set<TblColRef>, Set<TblColRef>> cols = ExpressionColCollector.collectColumnsPair(tupleExpression);
                boolean bl = ifPushDown = !this.afterAggregate;
                if (ifPushDown && !cols.getSecond().isEmpty()) {
                    ifPushDown = false;
                }
                if (ifPushDown) {
                    for (TblColRef dimCol : cols.getFirst()) {
                        if (this.context.belongToFactTableDims(dimCol)) continue;
                        ifPushDown = false;
                        break;
                    }
                }
                if (ifPushDown) {
                    this.groups.add(Sets.newHashSet(groupOutCol));
                    this.context.dynGroupBy.put(groupOutCol, tupleExpression);
                } else {
                    HashSet srcCols = Sets.newHashSet();
                    srcCols.addAll(cols.getFirst());
                    srcCols.addAll(cols.getSecond());
                    this.groups.add(srcCols);
                    this.context.dynamicFields.remove(groupOutCol);
                }
            } else {
                Set<TblColRef> srcCols = ExpressionColCollector.collectColumns(tupleExpression);
                if (srcCols.isEmpty()) {
                    srcCols.add(groupOutCol);
                }
                this.groups.add(srcCols);
            }
            i = this.getGroupSet().nextSetBit(i + 1);
        }
    }

    void buildAggregations() {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        this.aggregations = Lists.newArrayList();
        this.hackAggCalls = Maps.newHashMap();
        for (int i = 0; i < this.rewriteAggCalls.size(); ++i) {
            AggregateCall aggCall = this.rewriteAggCalls.get(i);
            ParameterDesc parameter = null;
            List<Integer> argList = aggCall.getArgList();
            if (!argList.isEmpty()) {
                ArrayList<TblColRef> columns = Lists.newArrayList();
                String funcName = OLAPAggregateRel.getSqlFuncName(aggCall);
                int columnsCount = aggCall.getArgList().size();
                if (AGGR_FUNC_PARAM_AS_MEASURE_MAP.containsKey(funcName)) {
                    int asMeasureCnt = AGGR_FUNC_PARAM_AS_MEASURE_MAP.get(funcName);
                    columnsCount = asMeasureCnt > 0 ? asMeasureCnt : (columnsCount += asMeasureCnt);
                }
                for (Integer index : aggCall.getArgList().subList(0, columnsCount)) {
                    TblColRef column = inputColumnRowType.getColumnByIndex(index);
                    columns.add(column);
                }
                if (!columns.isEmpty()) {
                    parameter = ParameterDesc.newInstance(columns.toArray(new TblColRef[columns.size()]));
                }
            }
            if (!this.afterAggregate && !this.rewriting) {
                if (this.context.isDynamicColumnEnabled() && argList.size() == 1) {
                    int iRowIdx = argList.get(0);
                    TupleExpression tupleExpr = inputColumnRowType.getTupleExpressionByIndex(iRowIdx);
                    if (aggCall.getAggregation() instanceof SqlSumAggFunction || aggCall.getAggregation() instanceof SqlSumEmptyIsZeroAggFunction) {
                        if (!(tupleExpr instanceof ConstantTupleExpression) && !(tupleExpr instanceof ColumnTupleExpression)) {
                            ColumnTupleExpression cntExpr = ColumnTupleExpression.getCntColumnTupleExpression();
                            ExpressionCountDistributor cntDistributor = new ExpressionCountDistributor(cntExpr);
                            tupleExpr = tupleExpr.accept(cntDistributor);
                            SumExpressionDynamicFunctionDesc sumDynFunc = new SumExpressionDynamicFunctionDesc(parameter, tupleExpr);
                            this.aggregations.add(sumDynFunc);
                            continue;
                        }
                    } else if (aggCall.getAggregation() instanceof SqlCountAggFunction) {
                        if (!aggCall.isDistinct()) {
                            boolean ifGood = true;
                            Set<TblColRef> cols = ExpressionColCollector.collectColumns(tupleExpr);
                            for (TblColRef col : cols) {
                                if (this.context.belongToFactTableDims(col)) continue;
                                ifGood = false;
                                break;
                            }
                            if (!ifGood) {
                                String expression = OLAPAggregateRel.getAggrFuncName(aggCall);
                                FunctionDesc aggFunc = FunctionDesc.newInstance(expression, parameter, null);
                                this.aggregations.add(aggFunc);
                                continue;
                            }
                            if ((tupleExpr = this.getCountSumExpression(tupleExpr)) == null) continue;
                            TblColRef column = TblColRef.newInnerColumn(tupleExpr.getDigest(), TblColRef.InnerDataTypeEnum.LITERAL);
                            SumExpressionDynamicFunctionDesc sumDynFunc = new SumExpressionDynamicFunctionDesc(ParameterDesc.newInstance(column), tupleExpr);
                            inputColumnRowType.replaceColumnByIndex(iRowIdx, column, tupleExpr);
                            AggregateCall newAggCall = AggregateCall.create(SqlStdOperatorTable.SUM0, false, aggCall.getArgList(), -1, aggCall.getType(), aggCall.getName());
                            this.hackAggCalls.put(i, newAggCall);
                            this.context.dynamicFields.put(column, aggCall.getType());
                            this.aggregations.add(sumDynFunc);
                            continue;
                        }
                        if (tupleExpr instanceof CaseTupleExpression) {
                            CaseTupleExpression caseTupleExpr = (CaseTupleExpression)tupleExpr;
                            if (caseTupleExpr.getWhenList().size() > 1 || caseTupleExpr.getElseExpr() != null) continue;
                            CountDistinctExpressionDynamicFunctionDesc cntDistDynFunc = new CountDistinctExpressionDynamicFunctionDesc(parameter, caseTupleExpr);
                            this.aggregations.add(cntDistDynFunc);
                            TblColRef colRef = cntDistDynFunc.getParameter().getColRef();
                            colRef.getColumnDesc().setDatatype(cntDistDynFunc.getRewriteFieldType().getName());
                            continue;
                        }
                    }
                }
                if (aggCall.getAggregation() instanceof SqlUserDefinedAggFunction && aggCall.getAggregation().getName().equals("STDDEV_SUM")) {
                    assert (argList.size() == 2);
                    TblColRef gbCol = inputColumnRowType.getColumnByIndex(argList.get(0));
                    TblColRef mCol = inputColumnRowType.getColumnByIndex(argList.get(1));
                    TblColRef column = TblColRef.newInnerColumn(StdDevSumFunctionDesc.getDigest(gbCol, mCol), TblColRef.InnerDataTypeEnum.LITERAL);
                    StdDevSumFunctionDesc stdDevSumFunc = new StdDevSumFunctionDesc(ParameterDesc.newInstance(column), Lists.newArrayList(gbCol, mCol));
                    inputColumnRowType.replaceColumnByIndex(argList.get(1), column, new ColumnTupleExpression(stdDevSumFunc.getRewriteFieldType(), column));
                    RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
                    RelDataType fieldType = OLAPTable.createSqlType(typeFactory, stdDevSumFunc.getRewriteFieldType(), true);
                    this.context.dynamicFields.put(column, fieldType);
                    this.aggregations.add(stdDevSumFunc);
                    continue;
                }
            }
            String expression = OLAPAggregateRel.getAggrFuncName(aggCall);
            FunctionDesc aggFunc = FunctionDesc.newInstance(expression, parameter, null);
            this.aggregations.add(aggFunc);
        }
    }

    public boolean needRewrite() {
        boolean hasRealization = null != this.context.realization;
        return hasRealization && !this.afterAggregate;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        if (this.needRewrite()) {
            this.translateAggregation();
            this.buildRewriteFieldsAndMetricsColumns();
        }
        implementor.visitChild(this, this.getInput());
        this.rewriting = true;
        if (this.needRewrite()) {
            this.rewriteAggCalls = Lists.newArrayListWithExpectedSize(this.aggCalls.size());
            for (int i = 0; i < this.aggCalls.size(); ++i) {
                AggregateCall aggCall;
                AggregateCall aggregateCall = aggCall = this.hackAggCalls.get(i) != null ? this.hackAggCalls.get(i) : (AggregateCall)this.aggCalls.get(i);
                if (SqlStdOperatorTable.GROUPING == aggCall.getAggregation()) {
                    this.rewriteAggCalls.add(aggCall);
                    continue;
                }
                FunctionDesc cubeFunc = this.context.aggregations.get(i);
                if (!this.noPrecaculatedFieldsAvailable() || !cubeFunc.needRewriteField()) {
                    if (cubeFunc.needRewrite()) {
                        aggCall = this.rewriteAggregateCall(aggCall, cubeFunc);
                    }
                    if (cubeFunc.getMeasureType() != null && cubeFunc.getMeasureType().needRewriteField()) {
                        aggCall = new KylinAggregateCall(aggCall, cubeFunc);
                    }
                } else {
                    logger.info(aggCall + "skip rewriteAggregateCall because no pre-aggregated field available");
                }
                this.rewriteAggCalls.add(aggCall);
                this.context.aggrSqlCalls.add(this.toSqlCall(aggCall));
            }
        }
        this.rowType = this.deriveRowType();
        this.columnRowType = this.buildColumnRowType();
        this.rewriting = false;
    }

    SQLDigest.SQLCall toSqlCall(AggregateCall aggCall) {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        String function = OLAPAggregateRel.getSqlFuncName(aggCall);
        ArrayList<Object> args = Lists.newArrayList();
        for (Integer index : aggCall.getArgList()) {
            TblColRef col = inputColumnRowType.getColumnByIndexNullable(index);
            args.add(col);
        }
        return new SQLDigest.SQLCall(function, args);
    }

    void translateAggregation() {
        if (!this.noPrecaculatedFieldsAvailable()) {
            List<MeasureDesc> measures = this.context.realization.getMeasures();
            ArrayList<FunctionDesc> newAggrs = Lists.newArrayList();
            for (FunctionDesc aggFunc : this.aggregations) {
                if (aggFunc instanceof DynamicFunctionDesc) {
                    if (!aggFunc.isDimensionAsMetric()) {
                        DynamicFunctionDesc dynAggFunc = (DynamicFunctionDesc)aggFunc;
                        Map<TblColRef, FunctionDesc> innerOldAggrs = dynAggFunc.getRuntimeFuncMap();
                        HashMap<TblColRef, FunctionDesc> innerNewAggrs = Maps.newHashMapWithExpectedSize(innerOldAggrs.size());
                        for (TblColRef key : innerOldAggrs.keySet()) {
                            innerNewAggrs.put(key, this.findInMeasures(innerOldAggrs.get(key), measures));
                        }
                        dynAggFunc.setRuntimeFuncMap(innerNewAggrs);
                        if (dynAggFunc instanceof CountDistinctExpressionDynamicFunctionDesc) {
                            dynAggFunc.setReturnType(((FunctionDesc)innerNewAggrs.values().iterator().next()).getReturnType());
                            TblColRef paramCol = aggFunc.getParameter().getColRefs().get(0);
                            RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
                            RelDataType fieldType = OLAPTable.createSqlType(typeFactory, dynAggFunc.getRewriteFieldType(), true);
                            this.context.dynamicFields.put(paramCol, fieldType);
                        }
                    } else {
                        TblColRef paramCol = aggFunc.getParameter().getColRefs().get(0);
                        this.context.dynamicFields.remove(paramCol);
                    }
                    newAggrs.add(aggFunc);
                    continue;
                }
                newAggrs.add(this.findInMeasures(aggFunc, measures));
            }
            this.aggregations.clear();
            this.aggregations.addAll(newAggrs);
            this.context.aggregations.clear();
            this.context.aggregations.addAll(newAggrs);
        }
    }

    FunctionDesc findInMeasures(FunctionDesc aggFunc, List<MeasureDesc> measures) {
        FunctionDesc func;
        for (MeasureDesc m : measures) {
            if (!aggFunc.equals(m.getFunction())) continue;
            return m.getFunction();
        }
        if (aggFunc.isCount() && (func = this.findCountConstantFunc(measures)) != null) {
            return func;
        }
        return aggFunc;
    }

    private FunctionDesc findCountConstantFunc(List<MeasureDesc> measures) {
        for (MeasureDesc measure : measures) {
            if (!measure.getFunction().isCountConstant()) continue;
            return measure.getFunction();
        }
        return null;
    }

    void buildRewriteFieldsAndMetricsColumns() {
        ColumnRowType inputColumnRowType = ((OLAPRel)this.getInput()).getColumnRowType();
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        for (int i = 0; i < this.aggregations.size(); ++i) {
            FunctionDesc aggFunc = this.aggregations.get(i);
            if (aggFunc.isDimensionAsMetric()) {
                List<TblColRef> neededCols = aggFunc instanceof ExpressionDynamicFunctionDesc ? Lists.newArrayList(ExpressionColCollector.collectColumns(((ExpressionDynamicFunctionDesc)aggFunc).getTupleExpression())) : aggFunc.getParameter().getColRefs();
                this.addToContextGroupBy(neededCols);
                continue;
            }
            ArrayList<FunctionDesc> aggFuncList = Lists.newArrayList(aggFunc);
            if (aggFunc instanceof DynamicFunctionDesc) {
                aggFuncList.addAll(((DynamicFunctionDesc)aggFunc).getRuntimeFuncMap().values());
            }
            for (FunctionDesc entry : aggFuncList) {
                if (!entry.needRewriteField()) continue;
                String rewriteFieldName = entry.getRewriteFieldName();
                RelDataType rewriteFieldType = OLAPTable.createSqlType(typeFactory, entry.getRewriteFieldType(), true);
                this.context.rewriteFields.put(rewriteFieldName, rewriteFieldType);
                TblColRef column = this.buildRewriteColumn(entry);
                this.context.metricsColumns.add(column);
            }
            AggregateCall aggCall = this.rewriteAggCalls.get(i);
            if (aggCall.getArgList().isEmpty()) continue;
            for (Integer index : aggCall.getArgList()) {
                TblColRef column = inputColumnRowType.getColumnByIndex(index);
                if (column.isInnerColumn() || !this.context.belongToContextTables(column)) continue;
                this.context.metricsColumns.add(column);
            }
        }
    }

    void addToContextGroupBy(List<TblColRef> colRefs) {
        for (TblColRef col : colRefs) {
            if (col.isInnerColumn() || !this.context.belongToContextTables(col)) continue;
            this.context.groupByColumns.add(col);
        }
    }

    public boolean noPrecaculatedFieldsAvailable() {
        return !this.context.hasPrecalculatedFields() || !OLAPRel.RewriteImplementor.needRewrite(this.context);
    }

    private AggregateCall rewriteAggregateCall(AggregateCall aggCall, FunctionDesc func) {
        String callName = OLAPAggregateRel.getSqlFuncName(aggCall);
        RelDataType fieldType = aggCall.getType();
        SqlAggFunction newAgg = aggCall.getAggregation();
        Map<String, Class<?>> udafMap = func.getMeasureType().getRewriteCalciteAggrFunctions();
        if (func.isCount()) {
            newAgg = SqlStdOperatorTable.SUM0;
        } else if (udafMap != null && udafMap.containsKey(callName)) {
            newAgg = this.createCustomAggFunction(callName, fieldType, udafMap.get(callName));
        }
        List<Integer> newArgList = Lists.newArrayList(aggCall.getArgList());
        if (udafMap != null && udafMap.containsKey(callName)) {
            newArgList = this.truncArgList(newArgList, udafMap.get(callName));
        }
        if (func.needRewriteField()) {
            RelDataTypeField field = this.getInput().getRowType().getField(func.getRewriteFieldName(), true, false);
            if (newArgList.isEmpty()) {
                newArgList.add(field.getIndex());
            } else {
                newArgList.set(0, field.getIndex());
            }
        }
        AggregateCall newAggCall = new AggregateCall(newAgg, false, newArgList, fieldType, callName);
        return newAggCall;
    }

    List<Integer> truncArgList(List<Integer> argList, Class<?> udafClazz) {
        int argListLength = argList.size();
        for (Method method : udafClazz.getMethods()) {
            if (!method.getName().equals("add")) continue;
            argListLength = Math.min(method.getParameterTypes().length - 1, argListLength);
        }
        return argList.subList(0, argListLength);
    }

    SqlAggFunction createCustomAggFunction(String funcName, RelDataType returnType, Class<?> customAggFuncClz) {
        RelDataTypeFactory typeFactory = this.getCluster().getTypeFactory();
        SqlIdentifier sqlIdentifier = new SqlIdentifier(funcName, new SqlParserPos(1, 1));
        AggregateFunctionImpl aggFunction = AggregateFunctionImpl.create(customAggFuncClz);
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<SqlTypeFamily> typeFamilies = new ArrayList<SqlTypeFamily>();
        for (FunctionParameter o : aggFunction.getParameters()) {
            RelDataType type = o.getType(typeFactory);
            argTypes.add(type);
            typeFamilies.add(Util.first(type.getSqlTypeName().getFamily(), SqlTypeFamily.ANY));
        }
        return new SqlUserDefinedAggFunction(sqlIdentifier, ReturnTypes.explicit(returnType), InferTypes.explicit(argTypes), OperandTypes.family(typeFamilies), aggFunction, false, false, typeFactory);
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        try {
            return new EnumerableAggregate(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE), OLAPAggregateRel.sole(inputs), this.indicator, this.groupSet, this.groupSets, this.rewriteAggCalls);
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException("Can't create EnumerableAggregate!", e);
        }
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    public List<AggregateCall> getRewriteAggCalls() {
        return this.rewriteAggCalls;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization);
    }

    private TupleExpression getCountSumExpression(TupleExpression tupleExpr) {
        ConstantTupleExpression zeroExpr = ConstantTupleExpression.ZERO;
        ColumnTupleExpression cntExpr = ColumnTupleExpression.getCntColumnTupleExpression();
        ArrayList<Pair<TupleFilter, TupleExpression>> whenList = Lists.newArrayListWithExpectedSize(1);
        if (tupleExpr instanceof ColumnTupleExpression) {
            CompareTupleFilter whenFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.ISNOTNULL);
            ((TupleFilter)whenFilter).addChild(new ColumnTupleFilter(((ColumnTupleExpression)tupleExpr).getColumn()));
            whenList.add(new Pair<CompareTupleFilter, ColumnTupleExpression>(whenFilter, cntExpr));
        } else if (tupleExpr instanceof CaseTupleExpression) {
            CaseTupleExpression caseTupleExpr = (CaseTupleExpression)tupleExpr;
            for (Pair<TupleFilter, TupleExpression> entry : caseTupleExpr.getWhenList()) {
                LogicalTupleFilter whenFilter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
                TupleFilter filter = this.getIsNotNullFilterFromExpression(entry.getSecond());
                if (filter == null) {
                    return null;
                }
                whenFilter.addChild(filter);
                whenFilter.addChild(entry.getFirst());
                whenList.add(new Pair<LogicalTupleFilter, ColumnTupleExpression>(whenFilter, cntExpr));
            }
            if (caseTupleExpr.getElseExpr() != null) {
                TupleFilter filter = this.getIsNotNullFilterFromExpression(caseTupleExpr.getElseExpr());
                if (filter == null) {
                    return null;
                }
                whenList.add(new Pair<TupleFilter, ColumnTupleExpression>(filter, cntExpr));
            }
        }
        CaseTupleExpression ret = new CaseTupleExpression(whenList, zeroExpr);
        ret.setDigest("_KY_COUNT(" + tupleExpr.getDigest() + ")");
        return ret;
    }

    private TupleFilter getIsNotNullFilterFromExpression(TupleExpression tupleExpr) {
        CompareTupleFilter filter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.ISNOTNULL);
        if (tupleExpr instanceof ColumnTupleExpression) {
            ((TupleFilter)filter).addChild(new ColumnTupleFilter(((ColumnTupleExpression)tupleExpr).getColumn()));
        } else if (tupleExpr instanceof ConstantTupleExpression) {
            ((TupleFilter)filter).addChild(new ConstantTupleFilter(((ConstantTupleExpression)tupleExpr).getValue()));
        } else {
            logger.warn("Cannot get IsNullFilter from Expression {}", (Object)tupleExpr);
            filter = null;
        }
        return filter;
    }

    static {
        AGGR_FUNC_MAP.put("SUM", "SUM");
        AGGR_FUNC_MAP.put("$SUM0", "SUM");
        AGGR_FUNC_MAP.put("COUNT", "COUNT");
        AGGR_FUNC_MAP.put("COUNT_DISTINCT", "COUNT_DISTINCT");
        AGGR_FUNC_MAP.put("MAX", "MAX");
        AGGR_FUNC_MAP.put("MIN", "MIN");
        AGGR_FUNC_MAP.put("GROUPING", "GROUPING");
        Map<String, MeasureTypeFactory> udafFactories = MeasureTypeFactory.getUDAFFactories();
        for (Map.Entry<String, MeasureTypeFactory> entry : udafFactories.entrySet()) {
            AGGR_FUNC_MAP.put(entry.getKey(), entry.getValue().getAggrFunctionName());
        }
        Map<String, Class<?>> udafs = MeasureTypeFactory.getUDAFs();
        for (String func : udafs.keySet()) {
            try {
                AGGR_FUNC_PARAM_AS_MEASURE_MAP.put(func, ((ParamAsMeasureCount)udafs.get(func).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getParamAsMeasureCount());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

