/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import com.google.common.base.Preconditions;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableSort;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;

public class OLAPSortRel
extends Sort
implements OLAPRel {
    ColumnRowType columnRowType;
    OLAPContext context;

    public OLAPSortRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
        Preconditions.checkArgument(this.getConvention() == OLAPRel.CONVENTION);
        Preconditions.checkArgument(this.getConvention() == child.getConvention());
    }

    @Override
    public OLAPSortRel copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new OLAPSortRel(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    @Override
    public void implementOLAP(OLAPRel.OLAPImplementor implementor) {
        implementor.fixSharedOlapTableScan(this);
        implementor.visitChild(this.getInput(), this);
        this.context = implementor.getContext();
        this.columnRowType = this.buildColumnRowType();
        for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
            int index = fieldCollation.getFieldIndex();
            SQLDigest.OrderEnum order = this.getOrderEnum(fieldCollation.getDirection());
            OLAPRel olapChild = (OLAPRel)this.getInput();
            TblColRef orderCol = olapChild.getColumnRowType().getAllColumns().get(index);
            this.context.addSort(orderCol, order);
            this.context.storageContext.markSort();
        }
    }

    ColumnRowType buildColumnRowType() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        ColumnRowType inputColumnRowType = olapChild.getColumnRowType();
        return inputColumnRowType;
    }

    @Override
    public void implementRewrite(OLAPRel.RewriteImplementor implementor) {
        implementor.visitChild(this, this.getInput());
        if (this.context.realization == null) {
            return;
        }
        this.rowType = this.deriveRowType();
        this.columnRowType = this.buildColumnRowType();
    }

    SQLDigest.OrderEnum getOrderEnum(RelFieldCollation.Direction direction) {
        if (direction == RelFieldCollation.Direction.DESCENDING) {
            return SQLDigest.OrderEnum.DESCENDING;
        }
        return SQLDigest.OrderEnum.ASCENDING;
    }

    MeasureDesc findMeasure(TblColRef col) {
        for (MeasureDesc measure : this.context.realization.getMeasures()) {
            if (!col.getName().equals(measure.getFunction().getRewriteFieldName())) continue;
            return measure;
        }
        return null;
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        return new EnumerableSort(this.getCluster(), this.getCluster().traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace(this.collation), OLAPSortRel.sole(inputs), this.collation, this.offset, this.fetch);
    }

    @Override
    public OLAPContext getContext() {
        return this.context;
    }

    @Override
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    public boolean hasSubQuery() {
        OLAPRel olapChild = (OLAPRel)this.getInput();
        return olapChild.hasSubQuery();
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("ctx", this.context == null ? "" : String.valueOf(this.context.id) + "@" + this.context.realization);
    }
}

