/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParamNodeParser {
    private static final Logger logger = LoggerFactory.getLogger(ParamNodeParser.class);
    private static final Pattern PARAM_PATTERN = Pattern.compile("\\$(\\d+)");

    ParamNodeParser() {
    }

    static int parseParamIdx(String paramNodeValue) {
        if (!StringUtils.isEmpty((String)paramNodeValue)) {
            try {
                Matcher m = PARAM_PATTERN.matcher(paramNodeValue);
                if (m.matches()) {
                    return Integer.parseInt(m.group(1));
                }
            }
            catch (Throwable e) {
                logger.error("Failed to parse the value to get the parameter id.", e);
            }
        }
        return -1;
    }
}

