/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.def;

import java.lang.reflect.Field;
import java.sql.Types;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import org.apache.kylin.sdk.datasource.framework.def.FunctionDef;
import org.apache.kylin.sdk.datasource.framework.def.PropertyDef;
import org.apache.kylin.sdk.datasource.framework.def.TypeDef;
import org.apache.kylin.sdk.datasource.framework.def.TypeMapping;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JacksonXmlRootElement(localName="DATASOURCE_DEF")
public class DataSourceDef {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceDef.class);
    @JacksonXmlProperty(localName="NAME", isAttribute=true)
    private String name;
    @JacksonXmlProperty(localName="ID", isAttribute=true)
    private String id;
    @JacksonXmlProperty(localName="DIALECT", isAttribute=true)
    private String dialect;
    @JacksonXmlProperty(localName="PROPERTY")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<PropertyDef> properties;
    @JacksonXmlProperty(localName="FUNCTION_DEF")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<FunctionDef> functions;
    @JacksonXmlProperty(localName="TYPE_DEF")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<TypeDef> types;
    @JacksonXmlProperty(localName="TYPE_MAPPING")
    @JacksonXmlElementWrapper(useWrapping=false)
    private List<TypeMapping> typeMappings;
    private Map<String, SqlNode> functionDefSqlNodeMap;
    private Map<String, List<String>> functionNameDefMap;
    private Map<String, TypeDef> typeDefMap;
    private Map<String, List<TypeDef>> typeNameDefMap;
    private Map<String, PropertyDef> propertyDefMap;
    private Map<String, Integer> dataTypeMap;
    private static final Map<String, Integer> TYPE_VALUES_MAP;

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void init() {
        this.functionDefSqlNodeMap = Maps.newHashMap();
        this.functionNameDefMap = Maps.newHashMap();
        this.typeNameDefMap = Maps.newHashMap();
        this.typeDefMap = Maps.newHashMap();
        this.propertyDefMap = Maps.newHashMap();
        this.dataTypeMap = Maps.newHashMap();
        if (this.functions != null) {
            for (FunctionDef function : this.functions) {
                function.init();
                try {
                    SqlParser sqlParser = SqlParser.create(function.getExpression());
                    SqlNode parsed = sqlParser.parseExpression();
                    if (parsed instanceof SqlCall || parsed instanceof SqlIdentifier) {
                        String name = parsed instanceof SqlCall ? ((SqlCall)parsed).getOperator().getName() : parsed.toString();
                        List<String> defIds = this.functionNameDefMap.get(name);
                        if (defIds == null) {
                            defIds = Lists.newLinkedList();
                            this.functionNameDefMap.put(name, defIds);
                        }
                        defIds.add(function.getId());
                        this.functionNameDefMap.put(name, defIds);
                        this.functionDefSqlNodeMap.put(function.getId(), parsed);
                        continue;
                    }
                    throw new IllegalStateException("Not a valid SqlCall.");
                }
                catch (Throwable e) {
                    logger.error("Failed to load function: ID={}, EXPRESSION={}", function.getId(), function.getExpression(), e);
                }
            }
        }
        if (this.types != null) {
            for (TypeDef type : this.types) {
                try {
                    type.init();
                    List<TypeDef> defs = this.typeNameDefMap.get(type.getName());
                    if (defs == null) {
                        defs = Lists.newLinkedList();
                        this.typeNameDefMap.put(type.getName(), defs);
                    }
                    defs.add(type);
                    this.typeDefMap.put(type.getId(), type);
                }
                catch (Throwable e) {
                    logger.error("Failed to load type: ID={}, NAME={}, EXPRESSION={}", type.getId(), type.getName(), type.getExpression());
                }
            }
        }
        if (this.properties != null) {
            for (PropertyDef prop : this.properties) {
                this.propertyDefMap.put(prop.getName().toLowerCase(Locale.ROOT), prop);
            }
        }
        if (this.typeMappings != null) {
            for (TypeMapping typeMapping : this.typeMappings) {
                String sourceType = typeMapping.getSourceType();
                String targetType = typeMapping.getTargetType();
                Integer typeValue = TYPE_VALUES_MAP.get(targetType.toUpperCase(Locale.ROOT));
                if (typeValue == null) {
                    logger.error("target dataType can not be found in java.sql.Types, SOURCE_TYPE={}, TARGET_TYPE={}", (Object)sourceType, (Object)targetType);
                    continue;
                }
                this.dataTypeMap.put(sourceType.toUpperCase(Locale.ROOT), typeValue);
            }
        }
        for (String k : this.propertyDefMap.keySet()) {
            logger.debug("Check {}, {} : {}", k, this.propertyDefMap.get(k).getName(), this.propertyDefMap.get(k).getValue());
        }
    }

    public SqlNode getFuncDefSqlNode(String id) {
        return this.functionDefSqlNodeMap.get(id.toUpperCase(Locale.ROOT));
    }

    public List<String> getFuncDefsByName(String name) {
        return this.functionNameDefMap.get(name.toUpperCase(Locale.ROOT));
    }

    public TypeDef getTypeDef(String id) {
        return this.typeDefMap.get(id.toUpperCase(Locale.ROOT));
    }

    public List<TypeDef> getTypeDefsByName(String typeName) {
        return this.typeNameDefMap.get(typeName.toUpperCase(Locale.ROOT));
    }

    public String getPropertyValue(String name) {
        return this.getPropertyValue(name, null);
    }

    public String getPropertyValue(String name, String defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        PropertyDef prop = this.propertyDefMap.get(name.toLowerCase(Locale.ROOT));
        return prop == null ? defaultValue : prop.getValue();
    }

    public String getValidationQuery() {
        return this.getPropertyValue("source.validation-query");
    }

    public Integer getDataTypeValue(String sourceType) {
        return this.dataTypeMap.get(sourceType.toUpperCase(Locale.ROOT));
    }

    public Map<String, TypeDef> getTypeDefMap() {
        return this.typeDefMap;
    }

    public String getDialectName() {
        return this.dialect;
    }

    static {
        Class<Types> clazz = Types.class;
        Field[] fileds = clazz.getDeclaredFields();
        TYPE_VALUES_MAP = new HashMap<String, Integer>(fileds.length);
        for (Field field : fileds) {
            try {
                TYPE_VALUES_MAP.put(field.getName(), field.getInt(clazz));
            }
            catch (IllegalAccessException e) {
                logger.error("failed to load java.sql.Types.", e);
            }
        }
    }
}

