/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class CubeMigrationCheckCLI {
    private static final Logger logger = LoggerFactory.getLogger(CubeMigrationCheckCLI.class);
    private static final Option OPTION_FIX;
    private static final Option OPTION_DST_CFG_URI;
    private static final Option OPTION_CUBE;
    private KylinConfig dstCfg;
    private Admin hbaseAdmin;
    private List<String> issueExistHTables;
    private List<String> inconsistentHTables;
    private boolean ifFix = false;

    public static void main(String[] args) throws ParseException, IOException {
        String cubeName;
        String dstCfgUri;
        logger.warn("org.apache.kylin.storage.hbase.util.CubeMigrationCheckCLI is deprecated, use org.apache.kylin.tool.CubeMigrationCheckCLI instead");
        OptionsHelper optionsHelper = new OptionsHelper();
        Options options = new Options();
        options.addOption(OPTION_FIX);
        options.addOption(OPTION_DST_CFG_URI);
        options.addOption(OPTION_CUBE);
        boolean ifFix = false;
        logger.info("jobs args: " + Arrays.toString(args));
        try {
            optionsHelper.parseOptions(options, args);
            logger.info("options: '" + options.toString() + "'");
            logger.info("option value 'fix': '" + optionsHelper.getOptionValue(OPTION_FIX) + "'");
            ifFix = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_FIX));
            logger.info("option value 'dstCfgUri': '" + optionsHelper.getOptionValue(OPTION_DST_CFG_URI) + "'");
            dstCfgUri = optionsHelper.getOptionValue(OPTION_DST_CFG_URI);
            logger.info("option value 'cube': '" + optionsHelper.getOptionValue(OPTION_CUBE) + "'");
            cubeName = optionsHelper.getOptionValue(OPTION_CUBE);
        }
        catch (ParseException e) {
            optionsHelper.printUsage(CubeMigrationCheckCLI.class.getName(), options);
            throw e;
        }
        KylinConfig kylinConfig = dstCfgUri == null ? KylinConfig.getInstanceFromEnv() : KylinConfig.createInstanceFromUri(dstCfgUri);
        CubeMigrationCheckCLI checkCLI = new CubeMigrationCheckCLI(kylinConfig, ifFix);
        checkCLI.execute(cubeName);
    }

    public void execute() throws IOException {
        this.execute(null);
    }

    public void execute(String cubeName) throws IOException {
        if (cubeName == null) {
            this.checkAll();
        } else {
            this.checkCube(cubeName);
        }
        this.fixInconsistent();
        this.printIssueExistingHTables();
    }

    public CubeMigrationCheckCLI(KylinConfig kylinConfig, Boolean isFix) throws IOException {
        this.dstCfg = kylinConfig;
        this.ifFix = isFix;
        Connection conn = HBaseConnection.get(kylinConfig.getStorageUrl());
        this.hbaseAdmin = conn.getAdmin();
        this.issueExistHTables = Lists.newArrayList();
        this.inconsistentHTables = Lists.newArrayList();
    }

    public void checkCube(String cubeName) {
        ArrayList<String> segFullNameList = Lists.newArrayList();
        CubeInstance cube = CubeManager.getInstance(this.dstCfg).getCube(cubeName);
        this.addHTableNamesForCube(cube, segFullNameList);
        this.check(segFullNameList);
    }

    public void checkAll() {
        ArrayList<String> segFullNameList = Lists.newArrayList();
        CubeManager cubeMgr = CubeManager.getInstance(this.dstCfg);
        for (CubeInstance cube : cubeMgr.listAllCubes()) {
            this.addHTableNamesForCube(cube, segFullNameList);
        }
        this.check(segFullNameList);
    }

    public void addHTableNamesForCube(CubeInstance cube, List<String> segFullNameList) {
        for (CubeSegment seg : cube.getSegments()) {
            String tableName = seg.getStorageLocationIdentifier();
            segFullNameList.add(tableName + "," + cube.getName());
        }
    }

    public void check(List<String> segFullNameList) {
        this.issueExistHTables = Lists.newArrayList();
        this.inconsistentHTables = Lists.newArrayList();
        for (String segFullName : segFullNameList) {
            String[] sepNameList = segFullName.split(",");
            try {
                HTableDescriptor hTableDescriptor = this.hbaseAdmin.getTableDescriptor(TableName.valueOf((String)sepNameList[0]));
                String host = hTableDescriptor.getValue("KYLIN_HOST");
                if (this.dstCfg.getMetadataUrlPrefix().equalsIgnoreCase(host)) continue;
                this.inconsistentHTables.add(segFullName);
            }
            catch (IOException e) {
                this.issueExistHTables.add(segFullName);
            }
        }
    }

    public void fixInconsistent() throws IOException {
        if (this.ifFix) {
            for (String segFullName : this.inconsistentHTables) {
                String[] sepNameList = segFullName.split(",");
                HTableDescriptor desc = this.hbaseAdmin.getTableDescriptor(TableName.valueOf((String)sepNameList[0]));
                logger.info("Change the host of htable " + sepNameList[0] + "belonging to cube " + sepNameList[1] + " from " + desc.getValue("KYLIN_HOST") + " to " + this.dstCfg.getMetadataUrlPrefix());
                this.hbaseAdmin.disableTable(TableName.valueOf((String)sepNameList[0]));
                desc.setValue("KYLIN_HOST", this.dstCfg.getMetadataUrlPrefix());
                this.hbaseAdmin.modifyTable(TableName.valueOf((String)sepNameList[0]), (TableDescriptor)desc);
                this.hbaseAdmin.enableTable(TableName.valueOf((String)sepNameList[0]));
            }
        } else {
            logger.info("------ Inconsistent HTables Needed To Be Fixed ------");
            for (String hTable : this.inconsistentHTables) {
                String[] sepNameList = hTable.split(",");
                logger.info(sepNameList[0] + " belonging to cube " + sepNameList[1]);
            }
            logger.info("----------------------------------------------------");
        }
    }

    public void printIssueExistingHTables() {
        logger.info("------ HTables exist issues in hbase : not existing, metadata broken ------");
        for (String segFullName : this.issueExistHTables) {
            String[] sepNameList = segFullName.split(",");
            logger.error(sepNameList[0] + " belonging to cube " + sepNameList[1] + " has some issues and cannot be read successfully!!!");
        }
        logger.info("----------------------------------------------------");
    }

    static {
        OptionBuilder.withArgName((String)"fix");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Fix the inconsistent cube segments' HOST");
        OPTION_FIX = OptionBuilder.create((String)"fix");
        OptionBuilder.withArgName((String)"dstCfgUri");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"The KylinConfig of the cube\u2019s new home");
        OPTION_DST_CFG_URI = OptionBuilder.create((String)"dstCfgUri");
        OptionBuilder.withArgName((String)"cube");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"The name of cube migrated");
        OPTION_CUBE = OptionBuilder.create((String)"cube");
    }
}

