/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.coordinator.assign;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.metadata.cachesync.Broadcaster;
import org.apache.kylin.shaded.com.google.common.cache.Cache;
import org.apache.kylin.shaded.com.google.common.cache.CacheBuilder;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.coordinator.StreamMetadataStore;
import org.apache.kylin.stream.coordinator.StreamMetadataStoreFactory;
import org.apache.kylin.stream.core.model.CubeAssignment;
import org.apache.kylin.stream.core.model.ReplicaSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssignmentsCache {
    private static final Logger logger = LoggerFactory.getLogger(AssignmentsCache.class);
    private static final AssignmentsCache instance = new AssignmentsCache();
    private static final String ASSIGNMENT_ENTITY = "cube_assign";
    private StreamMetadataStore metadataStore = StreamMetadataStoreFactory.getStreamMetaDataStore();
    private Cache<String, List<ReplicaSet>> cubeAssignmentCache;

    private AssignmentsCache() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        this.cubeAssignmentCache = CacheBuilder.newBuilder().removalListener(notification -> logger.debug("{} is removed because {} ", notification.getKey(), (Object)notification.getCause())).expireAfterWrite(300L, TimeUnit.SECONDS).build();
        Broadcaster.getInstance(config).registerListener(new AssignCacheSyncListener(), ASSIGNMENT_ENTITY);
    }

    public static AssignmentsCache getInstance() {
        return instance;
    }

    public List<ReplicaSet> getReplicaSetsByCube(String cubeName) {
        List ret;
        try {
            ret = this.cubeAssignmentCache.get(cubeName, () -> {
                ArrayList<ReplicaSet> result = Lists.newArrayList();
                CubeAssignment assignment = this.metadataStore.getAssignmentsByCube(cubeName);
                if (assignment == null) {
                    logger.error("Inconsistent metadata for assignment of {}, do check it.", (Object)cubeName);
                    return result;
                }
                for (Integer replicaSetID : assignment.getReplicaSetIDs()) {
                    result.add(this.metadataStore.getReplicaSet(replicaSetID));
                }
                logger.trace("Update assignment with {}", (Object)result);
                return result;
            });
        }
        catch (ExecutionException e) {
            logger.warn("Failed to load CubeAssignment", e);
            throw new IllegalStateException("Failed to load CubeAssignment", e);
        }
        return ret;
    }

    public void clearCubeCache(String cubeName) {
        Broadcaster.getInstance(KylinConfig.getInstanceFromEnv()).announce(ASSIGNMENT_ENTITY, Broadcaster.Event.UPDATE.getType(), cubeName);
        this.cubeAssignmentCache.invalidate(cubeName);
    }

    private class AssignCacheSyncListener
    extends Broadcaster.Listener {
        private AssignCacheSyncListener() {
        }

        @Override
        public void onEntityChange(Broadcaster broadcaster, String entity, Broadcaster.Event event, String cacheKey) {
            AssignmentsCache.this.cubeAssignmentCache.invalidate(cacheKey);
        }
    }
}

