/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.model.stats;

import java.util.List;
import java.util.Map;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.model.stats.ReceiverCubeStats;
import org.apache.kylin.stream.core.source.Partition;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreCacheStats;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class ReceiverStats {
    @JsonProperty(value="assignments")
    private Map<String, List<Partition>> assignments;
    @JsonProperty(value="is_lead")
    private boolean isLead;
    @JsonProperty(value="cube_stats")
    private Map<String, ReceiverCubeStats> cubeStatsMap = Maps.newHashMap();
    @JsonProperty(value="cache_stats")
    private ColumnarStoreCacheStats cacheStats;

    public void addCubeStats(String cubeName, ReceiverCubeStats cubeStats) {
        this.cubeStatsMap.put(cubeName, cubeStats);
    }

    public Map<String, List<Partition>> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(Map<String, List<Partition>> assignments) {
        this.assignments = assignments;
    }

    public boolean isLead() {
        return this.isLead;
    }

    public void setLead(boolean lead) {
        this.isLead = lead;
    }

    public Map<String, ReceiverCubeStats> getCubeStatsMap() {
        return this.cubeStatsMap;
    }

    public void setCubeStatsMap(Map<String, ReceiverCubeStats> cubeStatsMap) {
        this.cubeStatsMap = cubeStatsMap;
    }

    public ColumnarStoreCacheStats getCacheStats() {
        return this.cacheStats;
    }

    public void setCacheStats(ColumnarStoreCacheStats cacheStats) {
        this.cacheStats = cacheStats;
    }
}

