/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.query;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Set;
import org.apache.kylin.metadata.filter.BuiltInFunctionTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.DynamicTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.ITupleFilterTransformer;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingBuiltInFunctionTransformer
implements ITupleFilterTransformer {
    public static final Logger logger = LoggerFactory.getLogger(StreamingBuiltInFunctionTransformer.class);
    private Set<TblColRef> unEvaluableColumns;

    public StreamingBuiltInFunctionTransformer(Set<TblColRef> unEvaluableColumns) {
        this.unEvaluableColumns = unEvaluableColumns;
    }

    @Override
    public TupleFilter transform(TupleFilter tupleFilter) {
        TupleFilter result;
        TupleFilter translated = null;
        if (tupleFilter instanceof CompareTupleFilter) {
            translated = this.translateCompareTupleFilter((CompareTupleFilter)tupleFilter);
            if (translated != null) {
                logger.info("Translated {" + tupleFilter + "}");
            }
        } else if (tupleFilter instanceof BuiltInFunctionTupleFilter) {
            translated = this.translateFunctionTupleFilter((BuiltInFunctionTupleFilter)tupleFilter);
            if (translated != null) {
                logger.info("Translated {" + tupleFilter + "}");
            }
        } else if (tupleFilter instanceof LogicalTupleFilter) {
            ListIterator<? extends TupleFilter> childIterator = tupleFilter.getChildren().listIterator();
            while (childIterator.hasNext()) {
                TupleFilter transformed = this.transform(childIterator.next());
                if (transformed == null) continue;
                childIterator.set(transformed);
            }
        }
        TupleFilter tupleFilter2 = result = translated == null ? tupleFilter : translated;
        if (result.getOperator() == TupleFilter.FilterOperatorEnum.NOT && !TupleFilter.isEvaluableRecursively(result)) {
            TupleFilter.collectColumns(result, this.unEvaluableColumns);
            return ConstantTupleFilter.TRUE;
        }
        if (!result.isEvaluable()) {
            TupleFilter.collectColumns(result, this.unEvaluableColumns);
            return ConstantTupleFilter.TRUE;
        }
        return result;
    }

    private TupleFilter translateFunctionTupleFilter(BuiltInFunctionTupleFilter builtInFunctionTupleFilter) {
        if (!builtInFunctionTupleFilter.isValid()) {
            return null;
        }
        return new EvaluableBuildInFuncTupleFilter(builtInFunctionTupleFilter);
    }

    private TupleFilter translateCompareTupleFilter(CompareTupleFilter compTupleFilter) {
        if (compTupleFilter.getFunction() == null || !(compTupleFilter.getFunction() instanceof BuiltInFunctionTupleFilter)) {
            return null;
        }
        BuiltInFunctionTupleFilter buildInFunctionTupleFilter = (BuiltInFunctionTupleFilter)compTupleFilter.getFunction();
        if (!buildInFunctionTupleFilter.isValid()) {
            return null;
        }
        return new BuildInFuncCompareTupleFilter(compTupleFilter);
    }

    private static class EvaluableBuildInFuncTupleFilter
    extends TupleFilter {
        private BuiltInFunctionTupleFilter buildInFunctionTupleFilter;

        protected EvaluableBuildInFuncTupleFilter(BuiltInFunctionTupleFilter builtInFunctionTupleFilter) {
            super(new ArrayList<TupleFilter>(builtInFunctionTupleFilter.getChildren()), builtInFunctionTupleFilter.getOperator());
            this.buildInFunctionTupleFilter = builtInFunctionTupleFilter;
        }

        @Override
        public boolean isEvaluable() {
            return true;
        }

        public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem cs) {
            Object tupleValue = null;
            for (TupleFilter filter : this.children) {
                if (this.isConstant(filter)) continue;
                filter.evaluate(tuple, cs);
                tupleValue = filter.getValues().iterator().next();
            }
            if (tupleValue == null || cs.isNull(tupleValue)) {
                return false;
            }
            try {
                return (Boolean)this.buildInFunctionTupleFilter.invokeFunction(tupleValue);
            }
            catch (Exception e) {
                logger.error("error when invoke build in function", e);
                return false;
            }
        }

        @Override
        public Collection<?> getValues() {
            return null;
        }

        @Override
        public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        private boolean isConstant(TupleFilter filter) {
            return filter instanceof ConstantTupleFilter || filter instanceof DynamicTupleFilter;
        }
    }

    private static class BuildInFuncCompareTupleFilter
    extends TupleFilter {
        private CompareTupleFilter delegate;
        private BuiltInFunctionTupleFilter buildInFunctionTupleFilter;

        protected BuildInFuncCompareTupleFilter(CompareTupleFilter delegate) {
            super(new ArrayList<TupleFilter>(delegate.getChildren()), delegate.getOperator());
            this.delegate = delegate;
            this.buildInFunctionTupleFilter = (BuiltInFunctionTupleFilter)delegate.getFunction();
        }

        @Override
        public boolean isEvaluable() {
            return true;
        }

        public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem cs) {
            boolean result;
            Object tupleValue = null;
            for (TupleFilter tupleFilter : this.buildInFunctionTupleFilter.getChildren()) {
                if (this.isConstant(tupleFilter)) continue;
                tupleFilter.evaluate(tuple, cs);
                tupleValue = tupleFilter.getValues().iterator().next();
            }
            if (cs.isNull(tupleValue)) {
                return this.operator == TupleFilter.FilterOperatorEnum.ISNULL;
            }
            if (this.operator == TupleFilter.FilterOperatorEnum.ISNOTNULL) {
                return true;
            }
            if (this.delegate.getFirstValue() == null || cs.isNull(this.delegate.getFirstValue())) {
                return false;
            }
            Object computedVal = tupleValue;
            try {
                computedVal = this.buildInFunctionTupleFilter.invokeFunction(tupleValue);
            }
            catch (Exception exception) {
                logger.error("exception when invoke buildIn function", exception);
            }
            int n = cs.compare(computedVal, this.delegate.getFirstValue());
            switch (this.operator) {
                case EQ: {
                    result = n == 0;
                    break;
                }
                case NEQ: {
                    result = n != 0;
                    break;
                }
                case LT: {
                    result = n < 0;
                    break;
                }
                case LTE: {
                    result = n <= 0;
                    break;
                }
                case GT: {
                    result = n > 0;
                    break;
                }
                case GTE: {
                    result = n >= 0;
                    break;
                }
                case IN: {
                    result = this.delegate.getValues().contains(computedVal);
                    break;
                }
                case NOTIN: {
                    result = !this.delegate.getValues().contains(computedVal);
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        private boolean isConstant(TupleFilter filter) {
            return filter instanceof ConstantTupleFilter || filter instanceof DynamicTupleFilter;
        }

        @Override
        public Collection<?> getValues() {
            return this.delegate.getValues();
        }

        @Override
        public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
            throw new UnsupportedOperationException();
        }
    }
}

