/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.dict.DictionaryGenerator;
import org.apache.kylin.dict.DictionarySerializer;
import org.apache.kylin.dict.IterableDictionaryValueEnumerator;
import org.apache.kylin.dict.TrieDictionary;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.dimension.DimensionEncodingFactory;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.base.Function;
import org.apache.kylin.shaded.com.google.common.base.Stopwatch;
import org.apache.kylin.shaded.com.google.common.collect.Collections2;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.shaded.com.google.common.io.CountingOutputStream;
import org.apache.kylin.stream.core.exception.IllegalStorageException;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataWriter;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncoding;
import org.apache.kylin.stream.core.storage.columnar.ColumnarMetricsEncodingFactory;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreDimDesc;
import org.apache.kylin.stream.core.storage.columnar.ColumnarStoreMetricsDesc;
import org.apache.kylin.stream.core.storage.columnar.DataSegmentFragment;
import org.apache.kylin.stream.core.storage.columnar.ParsedStreamingCubeInfo;
import org.apache.kylin.stream.core.storage.columnar.SegmentMemoryStore;
import org.apache.kylin.stream.core.storage.columnar.invertindex.FixLenIIColumnDescriptor;
import org.apache.kylin.stream.core.storage.columnar.invertindex.IIColumnDescriptor;
import org.apache.kylin.stream.core.storage.columnar.invertindex.SeqIIColumnDescriptor;
import org.apache.kylin.stream.core.storage.columnar.protocol.CuboidMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimDictionaryMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimensionMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.FragmentMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.MetricMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnarMemoryStorePersister {
    private static Logger logger = LoggerFactory.getLogger(ColumnarMemoryStorePersister.class);
    private CubeDesc cubeDesc;
    private CubeInstance cubeInstance;
    private String segmentName;
    protected final TblColRef[] dimensions;
    protected final MeasureDesc[] measures;
    protected final Set<TblColRef> dimensionsUseDictEncoding;
    protected final long baseCuboidId;

    public ColumnarMemoryStorePersister(ParsedStreamingCubeInfo parsedCubeInfo, String segmentName) {
        this.cubeInstance = parsedCubeInfo.cubeInstance;
        this.cubeDesc = this.cubeInstance.getDescriptor();
        this.segmentName = segmentName;
        this.baseCuboidId = parsedCubeInfo.basicCuboid.getId();
        this.dimensions = parsedCubeInfo.dimensions;
        this.measures = parsedCubeInfo.measureDescs;
        this.dimensionsUseDictEncoding = Sets.newHashSet(parsedCubeInfo.dimensionsUseDictEncoding);
    }

    public void persist(SegmentMemoryStore memoryStore, DataSegmentFragment fragment) {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        logger.info("Start persist memory store for cube:{}, segment:{}, rowCnt:{}", this.cubeInstance.getName(), this.segmentName, memoryStore.getRowCount());
        try {
            this.persistDataFragment(memoryStore, fragment);
            stopwatch.stop();
            logger.info("Finish persist memory store for cube:{} segment:{}, take: {}ms", this.cubeInstance.getName(), this.segmentName, stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            logger.error("Error persist DataSegment, deleteing fragment folder:{}", (Object)fragment.getFragmentFolder().getPath());
            fragment.purge();
            throw new IllegalStorageException("Error persist DataSegment : " + e.getMessage(), e);
        }
    }

    private void persistDataFragment(SegmentMemoryStore memoryStore, DataSegmentFragment fragment) throws Exception {
        FragmentMetaInfo fragmentMeta = new FragmentMetaInfo();
        HashMap<String, CuboidMetaInfo> cuboidMetaInfoMap = Maps.newHashMap();
        fragmentMeta.setFragmentId(fragment.getFragmentId().toString());
        fragmentMeta.setMinEventTime(memoryStore.getMinEventTime());
        fragmentMeta.setMaxEventTime(memoryStore.getMaxEventTime());
        fragmentMeta.setOriginNumOfRows(memoryStore.getOriginRowCount());
        FileOutputStream fragmentOutputStream = FileUtils.openOutputStream((File)fragment.getDataFile());
        try (CountingOutputStream fragmentOut = new CountingOutputStream(new BufferedOutputStream(fragmentOutputStream));){
            ConcurrentMap<String[], MeasureAggregator[]> basicCuboidData = memoryStore.getBasicCuboidData();
            List<List<Object>> basicCuboidColumnarValues = this.transformToColumnar(this.baseCuboidId, this.dimensions.length, basicCuboidData);
            Map<TblColRef, Dictionary<String>> dictMap = this.buildAndPersistDictionaries(fragmentMeta, basicCuboidColumnarValues, fragmentOut);
            CuboidMetaInfo basicCuboidMeta = this.persistCuboidData(this.baseCuboidId, this.dimensions, dictMap, basicCuboidColumnarValues, fragmentOut);
            fragmentMeta.setBasicCuboidMetaInfo(basicCuboidMeta);
            long totalRowCnt = basicCuboidMeta.getNumberOfRows();
            Map<ParsedStreamingCubeInfo.CuboidInfo, ConcurrentMap<String[], MeasureAggregator[]>> additionalCuboidsData = memoryStore.getAdditionalCuboidsData();
            if (additionalCuboidsData != null && additionalCuboidsData.size() > 0) {
                for (Map.Entry<ParsedStreamingCubeInfo.CuboidInfo, ConcurrentMap<String[], MeasureAggregator[]>> cuboidDataEntry : additionalCuboidsData.entrySet()) {
                    ParsedStreamingCubeInfo.CuboidInfo cuboidInfo = cuboidDataEntry.getKey();
                    ConcurrentMap<String[], MeasureAggregator[]> cuboidData = cuboidDataEntry.getValue();
                    List<List<Object>> cuboidColumnarValues = this.transformToColumnar(cuboidInfo.getCuboidID(), cuboidInfo.getDimCount(), cuboidData);
                    CuboidMetaInfo cuboidMeta = this.persistCuboidData(cuboidInfo.getCuboidID(), cuboidInfo.getDimensions(), dictMap, cuboidColumnarValues, fragmentOut);
                    cuboidMetaInfoMap.put(String.valueOf(cuboidInfo.getCuboidID()), cuboidMeta);
                    totalRowCnt += cuboidMeta.getNumberOfRows();
                }
            }
            fragmentMeta.setNumberOfRows(totalRowCnt);
            fragmentMeta.setCuboidMetaInfoMap(cuboidMetaInfoMap);
        }
        FileOutputStream metaOutputStream = FileUtils.openOutputStream((File)fragment.getMetaFile());
        JsonUtil.writeValueIndent(metaOutputStream, fragmentMeta);
        metaOutputStream.flush();
        metaOutputStream.close();
    }

    private List<List<Object>> transformToColumnar(long cuboidId, int dimCnt, ConcurrentMap<String[], MeasureAggregator[]> aggBufMap) {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        int columnsNum = dimCnt + this.measures.length;
        ArrayList<List<Object>> columnarValues = Lists.newArrayListWithExpectedSize(columnsNum);
        for (int i = 0; i <= columnsNum; ++i) {
            LinkedList valueList = Lists.newLinkedList();
            columnarValues.add(valueList);
        }
        for (Map.Entry entry : aggBufMap.entrySet()) {
            String[] row = (String[])entry.getKey();
            MeasureAggregator[] measures = (MeasureAggregator[])entry.getValue();
            for (int i = 0; i < row.length; ++i) {
                String cell = row[i];
                List dimValueList = (List)columnarValues.get(i);
                dimValueList.add(cell);
            }
            for (int j = 0; j < measures.length; ++j) {
                MeasureAggregator measure = measures[j];
                List measureValueList = (List)columnarValues.get(dimCnt + j);
                measureValueList.add(measure.getState());
            }
        }
        stopwatch.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("cuboid-{} transform to columnar, take {} ms", (Object)cuboidId, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
        return columnarValues;
    }

    private Map<TblColRef, Dictionary<String>> buildAndPersistDictionaries(FragmentMetaInfo fragmentMetaInfo, List<List<Object>> allColumnarValues, CountingOutputStream fragmentOut) throws IOException {
        HashMap<TblColRef, Dictionary<String>> dictMaps = Maps.newHashMap();
        ArrayList<DimDictionaryMetaInfo> dimDictionaryMetaInfos = Lists.newArrayList();
        for (int i = 0; i < this.dimensions.length; ++i) {
            TblColRef dimension = this.dimensions[i];
            List<Object> dimValueList = allColumnarValues.get(i);
            DimDictionaryMetaInfo dimDictionaryMetaInfo = new DimDictionaryMetaInfo();
            if (!this.dimensionsUseDictEncoding.contains(dimension)) continue;
            Dictionary<String> dict = this.buildDictionary(dimension, dimValueList);
            dictMaps.put(dimension, dict);
            dimDictionaryMetaInfo.setDimName(dimension.getName());
            dimDictionaryMetaInfo.setDictType(dict.getClass().getName());
            dimDictionaryMetaInfo.setStartOffset((int)fragmentOut.getCount());
            DictionarySerializer.serialize(dict, fragmentOut);
            dimDictionaryMetaInfo.setDictLength((int)fragmentOut.getCount() - dimDictionaryMetaInfo.getStartOffset());
            dimDictionaryMetaInfos.add(dimDictionaryMetaInfo);
        }
        fragmentMetaInfo.setDimDictionaryMetaInfos(dimDictionaryMetaInfos);
        return dictMaps;
    }

    private CuboidMetaInfo persistCuboidData(long cuboidID, TblColRef[] dimensions, Map<TblColRef, Dictionary<String>> dictMaps, List<List<Object>> columnarCuboidValues, CountingOutputStream fragmentOutput) throws Exception {
        int i;
        CuboidMetaInfo cuboidMeta = new CuboidMetaInfo();
        int dimCnt = dimensions.length;
        ArrayList<DimensionMetaInfo> dimensionMetaList = Lists.newArrayListWithExpectedSize(dimCnt);
        cuboidMeta.setDimensionsInfo(dimensionMetaList);
        cuboidMeta.setNumberOfDim(dimCnt);
        ArrayList<MetricMetaInfo> metricMetaInfoList = Lists.newArrayListWithCapacity(this.measures.length);
        cuboidMeta.setMetricsInfo(metricMetaInfoList);
        cuboidMeta.setNumberOfMetrics(this.measures.length);
        long rowNum = -1L;
        for (i = 0; i < dimCnt; ++i) {
            if (rowNum == -1L) {
                rowNum = columnarCuboidValues.get(i).size();
            }
            this.persistDimension(cuboidID, columnarCuboidValues.get(i), dimensionMetaList, fragmentOutput, dimensions[i], dictMaps);
        }
        for (i = 0; i < this.measures.length; ++i) {
            this.persistMetric(cuboidID, columnarCuboidValues.get(dimCnt + i), metricMetaInfoList, i, fragmentOutput);
        }
        cuboidMeta.setNumberOfRows(rowNum);
        return cuboidMeta;
    }

    private void persistDimension(long cuboidId, List<Object> dimValueList, List<DimensionMetaInfo> dimensionMetaList, CountingOutputStream indexOut, TblColRef dimension, Map<TblColRef, Dictionary<String>> dictMaps) throws IOException {
        IIColumnDescriptor columnDescriptor;
        DimensionEncoding encoding;
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        DimensionMetaInfo dimensionMeta = new DimensionMetaInfo();
        dimensionMetaList.add(dimensionMeta);
        if (this.dimensionsUseDictEncoding.contains(dimension)) {
            Dictionary<String> dict = dictMaps.get(dimension);
            encoding = new DictionaryDimEnc(dict);
            columnDescriptor = dict instanceof TrieDictionary ? new SeqIIColumnDescriptor(dimension.getName(), dict.getMinId(), dict.getMaxId()) : new FixLenIIColumnDescriptor(dimension.getName(), encoding.getLengthOfEncoding());
        } else {
            RowKeyColDesc colDesc = this.cubeDesc.getRowkey().getColDesc(dimension);
            encoding = DimensionEncodingFactory.create(colDesc.getEncodingName(), colDesc.getEncodingArgs(), colDesc.getEncodingVersion());
            columnDescriptor = new FixLenIIColumnDescriptor(dimension.getName(), encoding.getLengthOfEncoding());
        }
        dimensionMeta.setName(dimension.getName());
        dimensionMeta.setStartOffset((int)indexOut.getCount());
        int fixEncodingLen = encoding.getLengthOfEncoding();
        DataOutputStream dataOut = new DataOutputStream(indexOut);
        ColumnarStoreDimDesc cStoreDimDesc = this.getColumnarStoreDimDesc(dimension, encoding);
        ColumnDataWriter columnDataWriter = cStoreDimDesc.getDimWriter(dataOut, dimValueList.size());
        for (Object cell : dimValueList) {
            byte[] fixLenBytes = new byte[fixEncodingLen];
            if (cell != null) {
                encoding.encode((String)cell, fixLenBytes, 0);
            } else {
                encoding.encode(null, fixLenBytes, 0);
                dimensionMeta.setHasNull(true);
            }
            columnDescriptor.getWriter().addValue(fixLenBytes);
            columnDataWriter.write(fixLenBytes);
        }
        columnDataWriter.flush();
        dimensionMeta.setDataLength(dataOut.size());
        columnDescriptor.getWriter().write(indexOut);
        dimensionMeta.setIndexLength((int)indexOut.getCount() - dimensionMeta.getStartOffset() - dimensionMeta.getDataLength());
        dimensionMeta.setCompression(cStoreDimDesc.getCompression().name());
        stopwatch.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("cuboid-{} saved dimension:{}, took: {}ms", cuboidId, dimension.getName(), stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private ColumnarStoreDimDesc getColumnarStoreDimDesc(TblColRef dimension, DimensionEncoding encoding) {
        return ColumnarStoreDimDesc.getDefaultCStoreDimDesc(this.cubeDesc, dimension.getName(), encoding);
    }

    private void persistMetric(long cuboidId, List<Object> metricValueList, List<MetricMetaInfo> metricMetaInfoList, int metricIdx, CountingOutputStream indexOut) throws IOException {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        MetricMetaInfo metricMeta = new MetricMetaInfo();
        metricMetaInfoList.add(metricMeta);
        String measureName = this.measures[metricIdx].getName();
        metricMeta.setName(measureName);
        metricMeta.setCol(metricIdx);
        metricMeta.setStartOffset((int)indexOut.getCount());
        DataType type = this.measures[metricIdx].getFunction().getReturnDataType();
        ColumnarMetricsEncoding metricsEncoding = ColumnarMetricsEncodingFactory.create(type);
        DataTypeSerializer<Object> serializer = metricsEncoding.asDataTypeSerializer();
        DataOutputStream metricsOut = new DataOutputStream(indexOut);
        int maxLength = serializer.maxLength();
        metricMeta.setMaxSerializeLength(maxLength);
        ByteBuffer metricsBuf = ByteBuffer.allocate(maxLength);
        ColumnarStoreMetricsDesc cStoreMetricsDesc = this.getColumnarStoreMetricsDesc(metricsEncoding);
        ColumnDataWriter metricsWriter = cStoreMetricsDesc.getMetricsWriter(metricsOut, metricValueList.size());
        for (Object metricValue : metricValueList) {
            metricsBuf.clear();
            serializer.serialize(metricValue, metricsBuf);
            byte[] metricBytes = Arrays.copyOf(metricsBuf.array(), metricsBuf.position());
            metricsWriter.write(metricBytes);
        }
        metricsWriter.flush();
        metricMeta.setMetricLength(metricsOut.size());
        metricMeta.setCompression(cStoreMetricsDesc.getCompression().name());
        stopwatch.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("cuboid-{} saved measure:{}, took: {}ms", cuboidId, measureName, stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private ColumnarStoreMetricsDesc getColumnarStoreMetricsDesc(ColumnarMetricsEncoding metricsEncoding) {
        return ColumnarStoreMetricsDesc.getDefaultCStoreMetricsDesc(metricsEncoding);
    }

    private Dictionary<String> buildDictionary(TblColRef dim, List<Object> inputValues) throws IOException {
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        stopwatch.start();
        Collection<String> values = Collections2.transform(Sets.newHashSet(inputValues), new Function<Object, String>(){

            @Override
            @Nullable
            public String apply(Object input) {
                String value = (String)input;
                return value;
            }
        });
        Dictionary<String> dict = DictionaryGenerator.buildDictionary(dim.getType(), new IterableDictionaryValueEnumerator(values));
        stopwatch.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("BuildDictionary for column : " + dim.getName() + " took : " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms ");
        }
        return dict;
    }
}

