/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.kylin.stream.core.storage.columnar.ColumnDataReader;

public class GeneralColumnDataReader
implements ColumnDataReader {
    private ByteBuffer dataBuffer;
    private int numOfVals;
    private int dataStartOffset;
    private int indexStartOffset;

    public GeneralColumnDataReader(ByteBuffer dataBuffer, int dataStartOffset, int dataLength) {
        this.dataBuffer = dataBuffer;
        this.dataStartOffset = dataStartOffset;
        dataBuffer.position(dataStartOffset + dataLength - 4);
        this.numOfVals = dataBuffer.getInt();
        this.indexStartOffset = dataStartOffset + dataLength - 4 - 4 * this.numOfVals;
    }

    @Override
    public byte[] read(int index) {
        int offset;
        if (index == 0) {
            offset = 0;
        } else {
            this.dataBuffer.position(this.indexStartOffset + (index - 1 << 2));
            offset = this.dataBuffer.getInt();
        }
        this.dataBuffer.position(this.dataStartOffset + offset);
        int length = this.dataBuffer.getInt();
        byte[] result = new byte[length];
        this.dataBuffer.get(result);
        return result;
    }

    @Override
    public Iterator<byte[]> iterator() {
        this.dataBuffer.position(this.dataStartOffset);
        return new Iterator<byte[]>(){
            int readRowCount = 0;

            @Override
            public boolean hasNext() {
                return this.readRowCount < GeneralColumnDataReader.this.numOfVals;
            }

            @Override
            public byte[] next() {
                int size = GeneralColumnDataReader.this.dataBuffer.getInt();
                byte[] result = new byte[size];
                GeneralColumnDataReader.this.dataBuffer.get(result);
                ++this.readRowCount;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("unSupport operation");
            }
        };
    }

    public ByteBuffer get(int index) {
        int offset;
        if (index == 0) {
            offset = 0;
        } else {
            this.dataBuffer.position(this.indexStartOffset + (index - 1 << 2));
            offset = this.dataBuffer.getInt();
        }
        ByteBuffer resultBuffer = this.dataBuffer.asReadOnlyBuffer();
        int startOffset = this.dataStartOffset + offset;
        resultBuffer.position(startOffset);
        int length = resultBuffer.getInt();
        resultBuffer.limit(startOffset + 4 + length);
        return resultBuffer;
    }

    public int getNumOfVals() {
        return this.numOfVals;
    }

    @Override
    public void close() throws IOException {
    }
}

