/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar;

import java.util.Arrays;

public class RawRecord {
    private byte[][] dimensions;
    private byte[][] metrics;

    public RawRecord(int dimNum, int metricNum) {
        this.dimensions = new byte[dimNum][];
        this.metrics = new byte[metricNum][];
    }

    public RawRecord(byte[][] dimensions, byte[][] metrics) {
        this.dimensions = dimensions;
        this.metrics = metrics;
    }

    public void copy(RawRecord another) {
        int i;
        if (another.getDimensions().length != this.dimensions.length || another.getMetrics().length != this.metrics.length) {
            throw new IllegalStateException("cannot copy record with different schema");
        }
        for (i = 0; i < another.dimensions.length; ++i) {
            this.dimensions[i] = new byte[another.dimensions[i].length];
            System.arraycopy(another.dimensions[i], 0, this.dimensions[i], 0, another.dimensions[i].length);
        }
        for (i = 0; i < another.metrics.length; ++i) {
            this.metrics[i] = new byte[another.metrics[i].length];
            System.arraycopy(another.metrics[i], 0, this.metrics[i], 0, another.metrics[i].length);
        }
    }

    public RawRecord clone() {
        int i;
        RawRecord rawRecord = new RawRecord(this.dimensions.length, this.metrics.length);
        for (i = 0; i < this.dimensions.length; ++i) {
            rawRecord.dimensions[i] = new byte[this.dimensions[i].length];
            System.arraycopy(this.dimensions[i], 0, rawRecord.dimensions[i], 0, this.dimensions[i].length);
        }
        for (i = 0; i < this.metrics.length; ++i) {
            rawRecord.metrics[i] = new byte[this.metrics[i].length];
            System.arraycopy(this.metrics[i], 0, rawRecord.metrics[i], 0, this.metrics[i].length);
        }
        return rawRecord;
    }

    public byte[][] getDimensions() {
        return this.dimensions;
    }

    public void setDimension(int idx, byte[] value) {
        this.dimensions[idx] = value;
    }

    public byte[][] getMetrics() {
        return this.metrics;
    }

    public void setMetric(int idx, byte[] value) {
        this.metrics[idx] = value;
    }

    public String toString() {
        return "Record{dimensions=" + Arrays.toString((Object[])this.dimensions) + ", metrics=" + Arrays.toString((Object[])this.metrics) + '}';
    }
}

