/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.core.storage.columnar.invertindex;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.job.shaded.org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.stream.core.storage.columnar.invertindex.ColInvertIndexSearcher;
import org.apache.kylin.stream.core.storage.columnar.invertindex.IndexSearchResult;
import org.apache.kylin.stream.core.storage.columnar.protocol.CuboidMetaInfo;
import org.apache.kylin.stream.core.storage.columnar.protocol.DimensionMetaInfo;

public class InvertIndexSearcher {
    Map<String, ColInvertIndexSearcher> colIndexSearchers = Maps.newHashMap();

    public InvertIndexSearcher(CuboidMetaInfo cuboidMetaInfo, TblColRef[] cols, ByteBuffer idxBuffer) throws IOException {
        HashMap<String, Pair<Integer, Integer>> columnMetas = Maps.newHashMap();
        for (DimensionMetaInfo dimensionMetaInfo : cuboidMetaInfo.getDimensionsInfo()) {
            for (TblColRef col : cols) {
                if (!dimensionMetaInfo.getName().equals(col.getName())) continue;
                columnMetas.put(col.getName(), new Pair<Integer, Integer>(dimensionMetaInfo.getStartOffset() + dimensionMetaInfo.getDataLength(), dimensionMetaInfo.getIndexLength()));
            }
        }
        for (Map.Entry entry : columnMetas.entrySet()) {
            String colName = (String)entry.getKey();
            Pair positionInfo = (Pair)entry.getValue();
            int offset = (Integer)positionInfo.getFirst();
            int length = (Integer)positionInfo.getSecond();
            ByteBuffer colIdxBuf = idxBuffer.asReadOnlyBuffer();
            colIdxBuf.position(offset);
            colIdxBuf.limit(offset + length);
            ColInvertIndexSearcher colIndexSearcher = ColInvertIndexSearcher.load(colIdxBuf);
            this.colIndexSearchers.put(colName, colIndexSearcher);
        }
    }

    public IndexSearchResult search(TupleFilter tupleFilter) {
        if (tupleFilter == null) {
            return null;
        }
        EvalResult evalResult = this.doEval(tupleFilter);
        IndexSearchResult result = new IndexSearchResult();
        result.allMatch = evalResult.allMatch;
        if (evalResult.bitmap != null) {
            result.rows = evalResult.bitmap.iterator();
        }
        return result;
    }

    public EvalResult doEval(TupleFilter filter) {
        if (filter == null) {
            return EvalResult.ALL_MATCH;
        }
        if (filter instanceof LogicalTupleFilter) {
            return this.doEvalLogical((LogicalTupleFilter)filter);
        }
        if (filter instanceof CompareTupleFilter) {
            return this.doEvalCompare((CompareTupleFilter)filter);
        }
        if (filter instanceof ConstantTupleFilter) {
            if (filter.getValues().size() == 0) {
                return new EvalResult();
            }
            if (filter.getValues().size() > 0) {
                return EvalResult.ALL_MATCH;
            }
        }
        return EvalResult.ALL_MATCH;
    }

    private EvalResult doEvalCompare(CompareTupleFilter filter) {
        switch (filter.getOperator()) {
            case EQ: {
                return this.doEvalCompareEqual(filter);
            }
            case IN: {
                return this.doEvalCompareIn(filter);
            }
            case ISNULL: {
                return this.doEvalCompareIsNull(filter);
            }
            case ISNOTNULL: {
                return this.doEvalCompareIsNotNull(filter);
            }
            case NEQ: {
                return this.doEvalCompareNotEqual(filter);
            }
            case NOTIN: {
                return this.doEvalCompareNotIn(filter);
            }
            case LT: {
                return this.doEvalCompareLT(filter);
            }
            case LTE: {
                return this.doEvalCompareLTE(filter);
            }
            case GT: {
                return this.doEvalCompareGT(filter);
            }
            case GTE: {
                return this.doEvalCompareGTE(filter);
            }
        }
        throw new IllegalStateException("Unsupported operator " + (Object)((Object)filter.getOperator()));
    }

    private EvalResult doEvalCompareGTE(CompareTupleFilter filter) {
        return EvalResult.ALL_MATCH;
    }

    private EvalResult doEvalCompareGT(CompareTupleFilter filter) {
        return EvalResult.ALL_MATCH;
    }

    private EvalResult doEvalCompareLTE(CompareTupleFilter filter) {
        return EvalResult.ALL_MATCH;
    }

    private EvalResult doEvalCompareLT(CompareTupleFilter filter) {
        return EvalResult.ALL_MATCH;
    }

    private EvalResult doEvalCompareNotIn(CompareTupleFilter filter) {
        return EvalResult.ALL_MATCH;
    }

    private EvalResult doEvalCompareNotEqual(CompareTupleFilter filter) {
        return EvalResult.ALL_MATCH;
    }

    private EvalResult doEvalCompareIsNotNull(CompareTupleFilter filter) {
        return EvalResult.ALL_MATCH;
    }

    private EvalResult doEvalCompareIsNull(CompareTupleFilter filter) {
        EvalResult result = new EvalResult();
        String column = filter.getColumn().getName();
        ColInvertIndexSearcher colSearcher = this.colIndexSearchers.get(column);
        if (colSearcher == null) {
            return EvalResult.ALL_MATCH;
        }
        ImmutableRoaringBitmap bitmap = colSearcher.searchValue(null);
        if (bitmap != null) {
            result.bitmap = bitmap;
        }
        return result;
    }

    private EvalResult doEvalCompareEqual(CompareTupleFilter filter) {
        EvalResult result = new EvalResult();
        String column = filter.getColumn().getName();
        byte[] value = null;
        if (filter.getFirstValue() instanceof ByteArray) {
            value = ((ByteArray)filter.getFirstValue()).array();
        } else if (filter.getFirstValue() instanceof byte[]) {
            value = (byte[])filter.getFirstValue();
        } else if (filter.getFirstValue() instanceof String) {
            value = Bytes.toBytes((String)filter.getFirstValue());
        }
        ColInvertIndexSearcher colSearcher = this.colIndexSearchers.get(column);
        if (colSearcher == null) {
            return EvalResult.ALL_MATCH;
        }
        ImmutableRoaringBitmap bitmap = colSearcher.searchValue(value);
        if (bitmap != null) {
            result.bitmap = bitmap;
        }
        return result;
    }

    private EvalResult doEvalCompareIn(CompareTupleFilter filter) {
        EvalResult result = new EvalResult();
        String column = filter.getColumn().getName();
        ColInvertIndexSearcher colSearcher = this.colIndexSearchers.get(column);
        if (colSearcher == null) {
            return EvalResult.ALL_MATCH;
        }
        ArrayList<ImmutableRoaringBitmap> bitmaps = Lists.newArrayList();
        for (Object value : filter.getValues()) {
            ImmutableRoaringBitmap bitmap;
            byte[] bytes = null;
            if (value instanceof ByteArray) {
                bytes = ((ByteArray)value).array();
            } else if (value instanceof byte[]) {
                bytes = (byte[])value;
            } else if (value instanceof String) {
                bytes = Bytes.toBytes((String)value);
            }
            if ((bitmap = colSearcher.searchValue(bytes)) == null) continue;
            bitmaps.add(bitmap);
        }
        if (bitmaps.isEmpty()) {
            return result;
        }
        result.bitmap = ImmutableRoaringBitmap.or(bitmaps.toArray(new ImmutableRoaringBitmap[bitmaps.size()]));
        return result;
    }

    private EvalResult doEvalLogical(LogicalTupleFilter filter) {
        List<? extends TupleFilter> children = filter.getChildren();
        switch (filter.getOperator()) {
            case AND: {
                return this.doEvalLogicalAnd(children);
            }
            case OR: {
                return this.doEvalLogicalOr(children);
            }
            case NOT: {
                return this.doEvalLogicalNot(children);
            }
        }
        throw new IllegalStateException("Unsupported operator " + (Object)((Object)filter.getOperator()));
    }

    private EvalResult doEvalLogicalAnd(List<? extends TupleFilter> children) {
        EvalResult result = new EvalResult();
        ArrayList<EvalResult> childResults = Lists.newArrayList();
        for (TupleFilter tupleFilter : children) {
            EvalResult childResult = this.doEval(tupleFilter);
            childResults.add(childResult);
            if (!childResult.isNoneMatch()) continue;
            break;
        }
        boolean childrenAllMatched = true;
        for (EvalResult childResult : childResults) {
            if (childResult.isNoneMatch()) {
                return new EvalResult();
            }
            if (childResult.isAllMatch()) continue;
            childrenAllMatched = false;
            ImmutableRoaringBitmap childBitmap = childResult.getBitmap();
            if (result.bitmap == null) {
                result.bitmap = childBitmap;
                continue;
            }
            result.bitmap = ImmutableRoaringBitmap.and(result.bitmap, childBitmap);
        }
        if (childrenAllMatched) {
            result.setAllMatch(true);
        }
        return result;
    }

    private EvalResult doEvalLogicalOr(List<? extends TupleFilter> children) {
        EvalResult result = new EvalResult();
        ArrayList<EvalResult> childResults = Lists.newArrayList();
        for (TupleFilter tupleFilter : children) {
            EvalResult childResult = this.doEval(tupleFilter);
            childResults.add(childResult);
            if (!childResult.isAllMatch()) continue;
            break;
        }
        for (EvalResult evalResult : childResults) {
            if (evalResult.isAllMatch()) {
                return EvalResult.ALL_MATCH;
            }
            if (evalResult.isNoneMatch()) continue;
            ImmutableRoaringBitmap childBitmap = evalResult.getBitmap();
            if (result.bitmap == null) {
                result.bitmap = childBitmap;
                continue;
            }
            result.bitmap = ImmutableRoaringBitmap.or(result.bitmap, childBitmap);
        }
        return result;
    }

    private EvalResult doEvalLogicalNot(List<? extends TupleFilter> children) {
        return EvalResult.ALL_MATCH;
    }

    private static class EvalResult {
        public static final EvalResult ALL_MATCH = new EvalResult(true, null);
        private boolean allMatch = false;
        private ImmutableRoaringBitmap bitmap;

        public EvalResult() {
            this(false, null);
        }

        public EvalResult(boolean allMatch, ImmutableRoaringBitmap bitmap) {
            this.allMatch = allMatch;
            this.bitmap = bitmap;
        }

        public boolean isAllMatch() {
            return this.allMatch;
        }

        public void setAllMatch(boolean allMatch) {
            this.allMatch = allMatch;
        }

        public boolean isNoneMatch() {
            return !this.allMatch && this.bitmap == null;
        }

        public ImmutableRoaringBitmap getBitmap() {
            return this.bitmap;
        }

        public void setBitmap(ImmutableRoaringBitmap bitmap) {
            this.bitmap = bitmap;
        }
    }
}

