/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.IOException;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.kylin.job.shaded.org.apache.commons.logging.Log;
import org.apache.kylin.job.shaded.org.apache.commons.logging.LogFactory;
import org.springframework.mock.web.portlet.MockMimeResponse;
import org.springframework.util.Assert;

public class MockPortletRequestDispatcher
implements PortletRequestDispatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String url;

    public MockPortletRequestDispatcher(String url) {
        Assert.notNull(url, "URL must not be null");
        this.url = url;
    }

    public void include(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        this.include((PortletRequest)request, (PortletResponse)response);
    }

    public void include(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        Assert.notNull(request, "Request must not be null");
        Assert.notNull(response, "Response must not be null");
        if (!(response instanceof MockMimeResponse)) {
            throw new IllegalArgumentException("MockPortletRequestDispatcher requires MockMimeResponse");
        }
        ((MockMimeResponse)response).setIncludedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MockPortletRequestDispatcher: including URL [" + this.url + "]");
        }
    }

    public void forward(PortletRequest request, PortletResponse response) throws PortletException, IOException {
        Assert.notNull(request, "Request must not be null");
        Assert.notNull(response, "Response must not be null");
        if (!(response instanceof MockMimeResponse)) {
            throw new IllegalArgumentException("MockPortletRequestDispatcher requires MockMimeResponse");
        }
        ((MockMimeResponse)response).setForwardedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("MockPortletRequestDispatcher: forwarding to URL [" + this.url + "]");
        }
    }
}

