/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson2;

import java.io.IOException;
import java.util.Set;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.job.shaded.com.fasterxml.jackson.databind.node.MissingNode;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;

class UserDeserializer
extends JsonDeserializer<User> {
    UserDeserializer() {
    }

    @Override
    public User deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(jp);
        Set<SimpleGrantedAuthority> authorities = mapper.convertValue((Object)jsonNode.get("authorities"), new TypeReference<Set<SimpleGrantedAuthority>>(){});
        JsonNode password = this.readJsonNode(jsonNode, "password");
        User result = new User(this.readJsonNode(jsonNode, "username").asText(), password.asText(""), this.readJsonNode(jsonNode, "enabled").asBoolean(), this.readJsonNode(jsonNode, "accountNonExpired").asBoolean(), this.readJsonNode(jsonNode, "credentialsNonExpired").asBoolean(), this.readJsonNode(jsonNode, "accountNonLocked").asBoolean(), authorities);
        if (password.asText(null) == null) {
            result.eraseCredentials();
        }
        return result;
    }

    private JsonNode readJsonNode(JsonNode jsonNode, String field) {
        return jsonNode.has(field) ? jsonNode.get(field) : MissingNode.getInstance();
    }
}

